/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
                while (generator.next()) {
                    SubmoduleStatus status = this.getStatus(generator);
                    statuses.put(status.getPath(), status);
                }
                return statuses;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId id = generator.getObjectId();
        String path = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path, id);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        ObjectId headId = null;
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            SubmoduleStatus submoduleStatus;
            Repository subRepo = generator.getRepository();
            try {
                if (subRepo == null) {
                    submoduleStatus = new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
                    return submoduleStatus;
                }
                headId = subRepo.resolve("HEAD");
            }
            finally {
                if (subRepo == null) return submoduleStatus;
                subRepo.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id, headId);
        }
        if (headId.equals(id)) return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path, id, headId);
        return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path, id, headId);
    }
}

