/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayDataBillAccountlogQueryDefaultResponse;
import com.alipay.v3.model.AlipayDataBillAccountlogQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayDataBillAccountlogApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayDataBillAccountlogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayDataBillAccountlogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/data/bill/accountlog/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (alipayOrderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alipay_order_no", alipayOrderNo));
        }
        if (merchantOrderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("merchant_order_no", merchantOrderNo));
        }
        if (pageNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_no", pageNo));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (transCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("trans_code", transCode));
        }
        if (agreementNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_no", agreementNo));
        }
        if (agreementProductCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_product_code", agreementProductCode));
        }
        if (billUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bill_user_id", billUserId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayDataBillAccountlogQueryResponseModel query(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId) throws ApiException {
        ApiResponse<AlipayDataBillAccountlogQueryResponseModel> localVarResp = this.queryWithHttpInfo(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, null);
        return localVarResp.getData();
    }

    public AlipayDataBillAccountlogQueryResponseModel query(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayDataBillAccountlogQueryResponseModel> localVarResp = this.queryWithHttpInfo(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayDataBillAccountlogQueryResponseModel> queryWithHttpInfo(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayDataBillAccountlogQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayDataBillAccountlogQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, ApiCallback<AlipayDataBillAccountlogQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayDataBillAccountlogQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String startTime, String endTime, String alipayOrderNo, String merchantOrderNo, String pageNo, String pageSize, String transCode, String agreementNo, String agreementProductCode, String billUserId, ApiCallback<AlipayDataBillAccountlogQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(startTime, endTime, alipayOrderNo, merchantOrderNo, pageNo, pageSize, transCode, agreementNo, agreementProductCode, billUserId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayDataBillAccountlogQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

