/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenAgentOfflinepaymentSignDefaultResponse;
import com.alipay.v3.model.AlipayOpenAgentOfflinepaymentSignModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenAgentOfflinepaymentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenAgentOfflinepaymentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenAgentOfflinepaymentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call signCall(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/agent/offlinepayment/sign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (businessLicensePic != null) {
            localVarFormParams.put("business_license_pic", businessLicensePic);
        }
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent())) {
            localVarFormParams.put("data", customizedParams.getBodyContent());
        }
        if (shopScenePic != null) {
            localVarFormParams.put("shop_scene_pic", shopScenePic);
        }
        if (shopSignBoardPic != null) {
            localVarFormParams.put("shop_sign_board_pic", shopSignBoardPic);
        }
        if (specialLicensePic != null) {
            localVarFormParams.put("special_license_pic", specialLicensePic);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call signValidateBeforeCall(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signCall(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, _callback, customizedParams);
        return localVarCall;
    }

    public Object sign(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic) throws ApiException {
        ApiResponse<Object> localVarResp = this.signWithHttpInfo(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, null);
        return localVarResp.getData();
    }

    public Object sign(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.signWithHttpInfo(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> signWithHttpInfo(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAgentOfflinepaymentSignDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call signAsync(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call signAsync(File businessLicensePic, AlipayOpenAgentOfflinepaymentSignModel data, File shopScenePic, File shopSignBoardPic, File specialLicensePic, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(businessLicensePic, data, shopScenePic, shopSignBoardPic, specialLicensePic, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

