/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenPublicAccountCreateDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicAccountCreateModel;
import com.alipay.v3.model.AlipayOpenPublicAccountCreateResponseModel;
import com.alipay.v3.model.AlipayOpenPublicAccountDeleteDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicAccountQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicAccountQueryResponseModel;
import com.alipay.v3.model.AlipayOpenPublicAccountResetDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicAccountResetModel;
import com.alipay.v3.model.AlipayOpenPublicAccountResetResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenPublicAccountApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenPublicAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenPublicAccountApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenPublicAccountCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenPublicAccountCreateModel;
        String localVarPath = "/v3/alipay/open/public/account/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayOpenPublicAccountCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenPublicAccountCreateResponseModel create(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenPublicAccountCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenPublicAccountCreateResponseModel create(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenPublicAccountCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenPublicAccountCreateResponseModel> createWithHttpInfo(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicAccountCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicAccountCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call createAsync(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, ApiCallback<AlipayOpenPublicAccountCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicAccountCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call createAsync(AlipayOpenPublicAccountCreateModel alipayOpenPublicAccountCreateModel, ApiCallback<AlipayOpenPublicAccountCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicAccountCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(String agreementId, String bindAccountNo, String fromUserId, String openId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/public/account/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (agreementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_id", agreementId));
        }
        if (bindAccountNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bind_account_no", bindAccountNo));
        }
        if (fromUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_user_id", fromUserId));
        }
        if (openId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_id", openId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String agreementId, String bindAccountNo, String fromUserId, String openId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(agreementId, bindAccountNo, fromUserId, openId, _callback, customizedParams);
        return localVarCall;
    }

    public Object delete(String agreementId, String bindAccountNo, String fromUserId, String openId) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(agreementId, bindAccountNo, fromUserId, openId, null);
        return localVarResp.getData();
    }

    public Object delete(String agreementId, String bindAccountNo, String fromUserId, String openId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(agreementId, bindAccountNo, fromUserId, openId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteWithHttpInfo(String agreementId, String bindAccountNo, String fromUserId, String openId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(agreementId, bindAccountNo, fromUserId, openId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicAccountDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call deleteAsync(String agreementId, String bindAccountNo, String fromUserId, String openId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(agreementId, bindAccountNo, fromUserId, openId, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call deleteAsync(String agreementId, String bindAccountNo, String fromUserId, String openId, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(agreementId, bindAccountNo, fromUserId, openId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String userId, String openId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/public/account/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (openId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_id", openId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String userId, String openId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(userId, openId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenPublicAccountQueryResponseModel query(String userId, String openId) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountQueryResponseModel> localVarResp = this.queryWithHttpInfo(userId, openId, null);
        return localVarResp.getData();
    }

    public AlipayOpenPublicAccountQueryResponseModel query(String userId, String openId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountQueryResponseModel> localVarResp = this.queryWithHttpInfo(userId, openId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenPublicAccountQueryResponseModel> queryWithHttpInfo(String userId, String openId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(userId, openId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicAccountQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String userId, String openId, ApiCallback<AlipayOpenPublicAccountQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(userId, openId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String userId, String openId, ApiCallback<AlipayOpenPublicAccountQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(userId, openId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetCall(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenPublicAccountResetModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenPublicAccountResetModel;
        String localVarPath = "/v3/alipay/open/public/account/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetValidateBeforeCall(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.resetCall(alipayOpenPublicAccountResetModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenPublicAccountResetResponseModel reset(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountResetResponseModel> localVarResp = this.resetWithHttpInfo(alipayOpenPublicAccountResetModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenPublicAccountResetResponseModel reset(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenPublicAccountResetResponseModel> localVarResp = this.resetWithHttpInfo(alipayOpenPublicAccountResetModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenPublicAccountResetResponseModel> resetWithHttpInfo(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.resetValidateBeforeCall(alipayOpenPublicAccountResetModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountResetResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicAccountResetDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call resetAsync(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, ApiCallback<AlipayOpenPublicAccountResetResponseModel> _callback) throws ApiException {
        Call localVarCall = this.resetValidateBeforeCall(alipayOpenPublicAccountResetModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountResetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call resetAsync(AlipayOpenPublicAccountResetModel alipayOpenPublicAccountResetModel, ApiCallback<AlipayOpenPublicAccountResetResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.resetValidateBeforeCall(alipayOpenPublicAccountResetModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicAccountResetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

