/*
 * Decompiled with CFR 0.152.
 */
package com.dlcg.oa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dlcg.oa.util.ApiHttpUtil;
import com.dlcg.oa.util.ExceptionInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OaHttpReq {
    @Value(value="${wxApiPath}")
    public String baseUrl;
    @Value(value="${wx_key}")
    public String pk;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getBaseUrl() {
        if (this.baseUrl == null || this.baseUrl.trim().length() <= 0) {
            this.logger.error("\u8bf7\u914d\u7f6ewxapi\u8bf7\u6c42\u8def\u5f84\uff01\u914d\u7f6e\u53c2\u6570\u3010wxApiPath=http://xxx.xxx.xxx\u3011\u5230\u914d\u7f6e\u6587\u4ef6");
        }
        return this.baseUrl;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void req(String path, Map<String, Object> paramMap) {
        this.req(path, paramMap, null);
    }

    public <T> T req(String path, Map<String, Object> paramMap, Class<T> clazz) {
        String result = ApiHttpUtil.post((String)(this.getBaseUrl() + path), (String)this.pk, paramMap);
        if (result == null || "".equals(result)) {
            this.logger.error("\u8bf7\u6c42\u5fae\u4fe1\u6a21\u5757\u8fd4\u56de\u4fe1\u606f\u4e3anull\u6216\u7a7a");
            return null;
        }
        this.logger.info("\u7f51\u7edc\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\uff1aresult=" + result);
        JSONObject obj = null;
        try {
            obj = JSON.parseObject((String)result);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u5fae\u4fe1\u6a21\u5757\u8fd4\u56de\u4fe1\u606f\u65e0\u6cd5\u89e3\u6790\u4e3aJSON\u683c\u5f0f\uff01\u5f02\u5e38\u4fe1\u606f:" + ExceptionInfo.toStr((Exception)e));
            return null;
        }
        Object res = null;
        if (!"0".equals(obj.getString("resultCode"))) {
            this.logger.error("\u63a5\u53e3\u5f02\u5e38\uff1a" + obj.getString("resultMsg"));
        } else if (clazz != null) {
            res = JSON.parseObject((String)obj.getString("result"), clazz);
        }
        return (T)res;
    }

    public static String urlencode(String url) {
        if (url == null || url.trim().length() <= 0) {
            return url;
        }
        try {
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }
}

