/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.Article;
import com.github.sd4324530.fastweixin.api.enums.MaterialType;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.DownloadMaterialResponse;
import com.github.sd4324530.fastweixin.api.response.GetMaterialListResponse;
import com.github.sd4324530.fastweixin.api.response.GetMaterialTotalCountResponse;
import com.github.sd4324530.fastweixin.api.response.UploadMaterialResponse;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MaterialAPI.class);

    public MaterialAPI(ApiConfig config) {
        super(config);
    }

    public UploadMaterialResponse uploadMaterialFile(File file) {
        return this.uploadMaterialFile(file, null, null);
    }

    public UploadMaterialResponse uploadMaterialFile(File file, String title, String introduction) {
        BaseResponse r;
        String url = "http://api.weixin.qq.com/cgi-bin/material/add_material?access_token=#";
        if (StrUtil.isBlank(title)) {
            r = this.executePost(url, null, file);
        } else {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("title", title);
            param.put("introduction", introduction);
            r = this.executePost(url, JSONUtil.toJson(param), file);
        }
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        UploadMaterialResponse response = JSONUtil.toBean(resultJson, UploadMaterialResponse.class);
        return response;
    }

    public UploadMaterialResponse uploadMaterialNews(List<Article> articles) {
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("articles", articles);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        UploadMaterialResponse response = JSONUtil.toBean(resultJson, UploadMaterialResponse.class);
        return response;
    }

    public DownloadMaterialResponse downloadMaterial(String mediaId, MaterialType type) {
        DownloadMaterialResponse response;
        block10: {
            response = new DownloadMaterialResponse();
            String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + this.config.getAccessToken();
            RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost request = new HttpPost(url);
            StringEntity mediaEntity = new StringEntity("{\"media_id\":\"" + mediaId + "\"}", ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)mediaEntity);
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = client.execute((HttpUriRequest)request);
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    switch (type) {
                        case NEWS: {
                            HttpEntity entity = httpResponse.getEntity();
                            String resultJson = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8"));
                            response = JSONUtil.toBean(resultJson, DownloadMaterialResponse.class);
                            LOG.debug("-----------------\u8bf7\u6c42\u6210\u529f-----------------");
                            LOG.debug("\u54cd\u5e94\u7ed3\u679c:");
                            LOG.debug(resultJson);
                            if (StrUtil.isBlank(response.getErrcode())) {
                                response.setErrcode("0");
                                response.setErrmsg(resultJson);
                                break;
                            }
                            break block10;
                        }
                        case VIDEO: {
                            HttpEntity entity = httpResponse.getEntity();
                            String resultJson = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8"));
                            LOG.debug("-----------------\u8bf7\u6c42\u6210\u529f-----------------");
                            LOG.debug("\u54cd\u5e94\u7ed3\u679c:");
                            LOG.debug(resultJson);
                            response = JSONUtil.toBean(resultJson, DownloadMaterialResponse.class);
                            if (StrUtil.isBlank(response.getErrcode())) {
                                response.setErrcode("0");
                                response.setErrmsg(resultJson);
                                this.downloadVideo(response);
                                break;
                            }
                            break block10;
                        }
                        default: {
                            Header length = httpResponse.getHeaders("Content-Length")[0];
                            InputStream inputStream = httpResponse.getEntity().getContent();
                            response.setContent(inputStream, Integer.valueOf(length.getValue()));
                            break;
                        }
                    }
                    break block10;
                }
                response.setErrcode(String.valueOf(httpResponse.getStatusLine().getStatusCode()));
                response.setErrmsg("\u8bf7\u6c42\u5931\u8d25");
            }
            catch (IOException e) {
                LOG.error("IO\u6d41\u5f02\u5e38", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
            }
        }
        return response;
    }

    public GetMaterialTotalCountResponse countMaterial() {
        GetMaterialTotalCountResponse response = null;
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetMaterialTotalCountResponse.class);
        return response;
    }

    public GetMaterialListResponse batchGetMaterial(MaterialType type, int offset, int count) {
        if (offset < 0) {
            offset = 0;
        }
        if (count > 20) {
            count = 20;
        }
        if (count < 1) {
            count = 1;
        }
        GetMaterialListResponse response = null;
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>(4, 1.0f);
        params.put("type", type.toString());
        params.put("offset", offset);
        params.put("count", count);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetMaterialListResponse.class);
        return response;
    }

    public ResultType deleteMaterial(String mediaId) {
        String url = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("media_id", mediaId);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    private void downloadVideo(DownloadMaterialResponse response) {
        String url = response.getDownUrl();
        LOG.debug("Download url: " + url);
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse r = client.execute((HttpUriRequest)get);
            if (200 == r.getStatusLine().getStatusCode()) {
                InputStream inputStream = r.getEntity().getContent();
                Header[] headers = r.getHeaders("Content-disposition");
                Header length = r.getHeaders("Content-Length")[0];
                response.setContent(inputStream, Integer.valueOf(length.getValue()));
                response.setFileName(headers[0].getElements()[0].getParameterByName("filename").getValue());
            }
        }
        catch (IOException e) {
            LOG.error("IO\u5f02\u5e38\u5904\u7406", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
        }
    }
}

