/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.CustomAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.Industry;
import com.github.sd4324530.fastweixin.api.entity.TemplateMsg;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.AddTemplateResponse;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.SendTemplateResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMsgAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAPI.class);

    public TemplateMsgAPI(ApiConfig config) {
        super(config);
    }

    public ResultType setIndustry(Industry industry) {
        LOG.debug("\u8bbe\u7f6e\u884c\u4e1a......");
        BeanUtil.requireNonNull(industry, "\u884c\u4e1a\u5bf9\u8c61\u4e3a\u7a7a");
        String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=#";
        BaseResponse response = this.executePost(url, industry.toJsonString());
        return ResultType.get(response.getErrcode());
    }

    public AddTemplateResponse addTemplate(String shortTemplateId) {
        LOG.debug("\u83b7\u53d6\u6a21\u7248id......");
        BeanUtil.requireNonNull(shortTemplateId, "\u77ed\u6a21\u7248id\u5fc5\u586b");
        String url = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template_id_short", shortTemplateId);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        AddTemplateResponse result = JSONUtil.toBean(resultJson, AddTemplateResponse.class);
        return result;
    }

    public SendTemplateResponse send(TemplateMsg msg) {
        LOG.debug("\u83b7\u53d6\u6a21\u7248id......");
        BeanUtil.requireNonNull(msg.getTouser(), "openid is null");
        BeanUtil.requireNonNull(msg.getTemplateId(), "template_id is null");
        BeanUtil.requireNonNull(msg.getData(), "data is null");
        BeanUtil.requireNonNull(msg.getTopcolor(), "top color is null");
        BeanUtil.requireNonNull(msg.getUrl(), "url is null");
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=#";
        BaseResponse r = this.executePost(url, msg.toJsonString());
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        SendTemplateResponse result = JSONUtil.toBean(resultJson, SendTemplateResponse.class);
        return result;
    }
}

