/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.UserInfo;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.CreateGroupResponse;
import com.github.sd4324530.fastweixin.api.response.GetGroupsResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserInfoListResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserInfoResponse;
import com.github.sd4324530.fastweixin.api.response.GetUsersResponse;
import com.github.sd4324530.fastweixin.exception.WeixinException;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(UserAPI.class);

    public UserAPI(ApiConfig config) {
        super(config);
    }

    public GetUsersResponse getUsers(String nextOpenid) {
        BaseResponse r;
        LOG.debug("\u83b7\u53d6\u5173\u6ce8\u8005\u5217\u8868.....");
        String url = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=#";
        if (StrUtil.isNotBlank(nextOpenid)) {
            url = url + "&next_openid=" + nextOpenid;
        }
        String resultJson = this.isSuccess((r = this.executeGet(url)).getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetUsersResponse response = JSONUtil.toBean(resultJson, GetUsersResponse.class);
        return response;
    }

    public ResultType setUserRemark(String openid, String remark) {
        BeanUtil.requireNonNull(openid, "openid is null");
        LOG.debug("\u8bbe\u7f6e\u5173\u6ce8\u8005\u5907\u6ce8.....");
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("openid", openid);
        param.put("remark", remark);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public CreateGroupResponse createGroup(String name) {
        BeanUtil.requireNonNull(name, "name is null");
        LOG.debug("\u521b\u5efa\u5206\u7ec4.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/create?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> group = new HashMap<String, String>();
        group.put("name", name);
        param.put("group", group);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(param));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        CreateGroupResponse response = JSONUtil.toBean(resultJson, CreateGroupResponse.class);
        return response;
    }

    public GetGroupsResponse getGroups() {
        LOG.debug("\u83b7\u53d6\u6240\u6709\u5206\u7ec4\u4fe1\u606f.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/get?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetGroupsResponse response = JSONUtil.toBean(resultJson, GetGroupsResponse.class);
        return response;
    }

    public String getGroupIdByOpenid(String openid) {
        BeanUtil.requireNonNull(openid, "openid is null");
        LOG.debug("\u901a\u8fc7\u5173\u6ce8\u8005ID\u83b7\u53d6\u6240\u5728\u5206\u7ec4\u4fe1\u606f.....");
        String result = null;
        String url = "https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("openid", openid);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        if (this.isSuccess(r.getErrcode())) {
            result = JSONUtil.toMap(r.getErrmsg()).get("groupid").toString();
        }
        return result;
    }

    public ResultType updateGroup(Integer groupid, String name) {
        BeanUtil.requireNonNull(groupid, "groupid is null");
        BeanUtil.requireNonNull(name, "name is null");
        LOG.debug("\u4fee\u6539\u5206\u7ec4\u4fe1\u606f.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/update?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> group = new HashMap<String, Object>();
        group.put("id", groupid);
        group.put("name", name);
        param.put("group", group);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public ResultType moveGroupUser(String openid, String toGroupid) {
        BeanUtil.requireNonNull(openid, "openid is null");
        BeanUtil.requireNonNull(toGroupid, "toGroupid is null");
        LOG.debug("\u79fb\u52a8\u5173\u6ce8\u8005\u6240\u5728\u5206\u7ec4.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("openid", openid);
        param.put("to_groupid", toGroupid);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public ResultType moveGroupUser(String[] openids, String toGroupid) {
        BeanUtil.requireNonNull(openids, "openid is null");
        BeanUtil.requireNonNull(toGroupid, "toGroupid is null");
        LOG.debug("\u79fb\u52a8\u5173\u6ce8\u8005\u6240\u5728\u5206\u7ec4.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/members/batchupdate?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("openid_list", openids);
        param.put("to_groupid", toGroupid);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public GetUserInfoResponse getUserInfo(String openid) {
        BeanUtil.requireNonNull(openid, "openid is null");
        LOG.debug("\u83b7\u53d6\u5173\u6ce8\u8005\u4fe1\u606f.....");
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=#&lang=zh_CN&openid=" + openid;
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetUserInfoResponse response = JSONUtil.toBean(resultJson, GetUserInfoResponse.class);
        return response;
    }

    public GetUserInfoListResponse getUserInfoList(List<UserInfo> userInfoList) {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=#";
        HashMap<String, List<UserInfo>> param = new HashMap<String, List<UserInfo>>();
        param.put("user_list", userInfoList);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(param));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetUserInfoListResponse getUserInfoListResponse = JSONUtil.toBean(resultJson, GetUserInfoListResponse.class);
        return getUserInfoListResponse;
    }

    public ResultType deleteGroup(Integer groupId) {
        BeanUtil.requireNonNull(groupId, "groupId is null");
        LOG.debug("\u5220\u9664\u5206\u7ec4.....");
        String url = "https://api.weixin.qq.com/cgi-bin/groups/delete?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Integer> groups = new HashMap<String, Integer>();
        groups.put("id", groupId);
        param.put("group", groups);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public ResultType batchTagsToUser(List<String> openidList, Integer tagId) {
        BeanUtil.requireNonNull(tagId, "tagId is null");
        if (CollectionUtil.isEmpty(openidList)) {
            throw new WeixinException("openId\u5217\u8868\u4e3a\u7a7a");
        }
        LOG.debug("\u6279\u91cf\u4e3a\u7528\u6237\u6253\u4e0a\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("openid_list", openidList);
        param.put("tagid", tagId);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public ResultType batchDeleteTagsToUser(List<String> openidList, Integer tagId) {
        BeanUtil.requireNonNull(tagId, "tagId is null");
        if (CollectionUtil.isEmpty(openidList)) {
            throw new WeixinException("openId\u5217\u8868\u4e3a\u7a7a");
        }
        LOG.debug("\u6279\u91cf\u4e3a\u7528\u6237\u53d6\u6d88\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("openid_list", openidList);
        param.put("tagid", tagId);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }
}

