/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.enums.MediaType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.response.DownloadMediaResponse;
import com.github.sd4324530.fastweixin.company.api.response.UploadMediaResponse;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QYMediaAPI
extends QYBaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QYMediaAPI.class);

    public QYMediaAPI(QYAPIConfig config) {
        super(config);
    }

    public UploadMediaResponse upload(MediaType type, File file) {
        if (type == MediaType.NEWS) {
            LOG.debug("\u4f01\u4e1a\u53f7\u5a92\u4f53\u7d20\u6750\u4e0d\u5305\u542b\u65b0\u95fb\u5217\u8868");
            return null;
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?access_token=#&type=" + type.toString();
        BaseResponse r = this.executePost(url, null, file);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        UploadMediaResponse response = JSONUtil.toBean(resultJson, UploadMediaResponse.class);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadMediaResponse download(String mediaId) {
        DownloadMediaResponse response = new DownloadMediaResponse();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=" + this.config.getAccessToken() + "&media_id=" + mediaId;
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse r = client.execute((HttpUriRequest)get);
            if (200 == r.getStatusLine().getStatusCode()) {
                InputStream inputStream = r.getEntity().getContent();
                Header[] headers = r.getHeaders("Content-disposition");
                if (null != headers && 0 != headers.length) {
                    Header length = r.getHeaders("Content-Length")[0];
                    response.setContent(inputStream, Integer.valueOf(length.getValue()));
                    response.setFileName(headers[0].getElements()[0].getParameterByName("filename").getValue());
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    StreamUtil.copy(inputStream, out);
                    String json = out.toString();
                    response = JSONUtil.toBean(json, DownloadMediaResponse.class);
                }
            }
        }
        catch (Exception e) {
            LOG.error("\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                LOG.error("\u5f02\u5e38", (Throwable)e);
            }
        }
        return response;
    }
}

