/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.entity.QYTag;
import com.github.sd4324530.fastweixin.company.api.enums.QYResultType;
import com.github.sd4324530.fastweixin.company.api.response.AddTagUsersResponse;
import com.github.sd4324530.fastweixin.company.api.response.CreateTagResponse;
import com.github.sd4324530.fastweixin.company.api.response.DelTagUsersResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetTagInfoResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetTagListResponse;
import com.github.sd4324530.fastweixin.exception.WeixinException;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QYTagAPI
extends QYBaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QYTagAPI.class);

    public QYTagAPI(QYAPIConfig config) {
        super(config);
    }

    public CreateTagResponse create(QYTag tag) {
        BaseResponse r;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/create?access_token=#";
        if (StrUtil.isBlank(tag.getTagname())) {
            throw new WeixinException("\u6807\u7b7e\u540d\u79f0\u5fc5\u987b\u586b\u5199!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tag content: {}", (Object)tag.toJsonString());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tagname", tag.getTagname());
        if (tag.getTagid() != null) {
            params.put("tagid", tag.getTagid());
        }
        String jsonResult = this.isSuccess((r = this.executePost(url, JSONUtil.toJson(params))).getErrcode()) ? r.getErrmsg() : r.toJsonString();
        CreateTagResponse response = JSONUtil.toBean(jsonResult, CreateTagResponse.class);
        return response;
    }

    public QYResultType delete(Integer tagid) {
        BeanUtil.requireNonNull(tagid, "tagid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/delete?access_token=#&tagid=" + tagid;
        BaseResponse response = this.executeGet(url);
        return QYResultType.get(response.getErrcode());
    }

    public GetTagInfoResponse get(Integer tagid) {
        BeanUtil.requireNonNull(tagid, "tagid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/get?access_token=#&tagid=" + tagid;
        BaseResponse r = this.executeGet(url);
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetTagInfoResponse response = JSONUtil.toBean(jsonResult, GetTagInfoResponse.class);
        return response;
    }

    public AddTagUsersResponse addTagUsers(Integer tagid, List<String> users, List<Integer> partys) {
        BeanUtil.requireNonNull(tagid, "tagid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!(users != null && users.size() != 0 || partys != null && partys.size() != 0)) {
            throw new WeixinException("userlist\u3001partylist\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (users != null && users.size() > 1000) {
            throw new WeixinException("userlist\u5355\u6b21\u8bf7\u6c42\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e1000");
        }
        if (partys != null && partys.size() > 100) {
            throw new WeixinException("partylist\u5355\u6b21\u8bf7\u6c42\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100");
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/addtagusers?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tagid", tagid);
        params.put("userlist", users);
        params.put("partylist", partys);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        AddTagUsersResponse response = JSONUtil.toBean(jsonResult, AddTagUsersResponse.class);
        return response;
    }

    public DelTagUsersResponse delTagUsers(Integer tagid, List<String> users, List<Integer> partys) {
        BeanUtil.requireNonNull(tagid, "tagid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!(users != null && users.size() != 0 || partys != null && partys.size() != 0)) {
            throw new WeixinException("userlist\u3001partylist\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/deltagusers?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tagid", tagid);
        params.put("userlist", users);
        params.put("partylist", partys);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        DelTagUsersResponse response = JSONUtil.toBean(jsonResult, DelTagUsersResponse.class);
        return response;
    }

    public GetTagListResponse list() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/list?access_token=#";
        BaseResponse r = this.executeGet(url);
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetTagListResponse response = JSONUtil.toBean(jsonResult, GetTagListResponse.class);
        return response;
    }
}

