/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.message.resp;

import com.github.sd4324530.fastweixin.company.message.QYArticle;
import com.github.sd4324530.fastweixin.company.message.resp.QYBaseRespMsg;
import com.github.sd4324530.fastweixin.message.util.MessageBuilder;
import java.util.ArrayList;
import java.util.List;

public class QYNewsRespMsg
extends QYBaseRespMsg {
    private static final int WX_MAX_SIZE = 10;
    private int maxSize = 10;
    private List<QYArticle> articles;

    public QYNewsRespMsg() {
        this.articles = new ArrayList<QYArticle>(this.maxSize);
    }

    public QYNewsRespMsg(int maxSize) {
        this.setMaxSize(maxSize);
        this.articles = new ArrayList<QYArticle>(maxSize);
    }

    public QYNewsRespMsg(List<QYArticle> articles) {
        this.articles = articles;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 10 && maxSize >= 1) {
            this.maxSize = maxSize;
        }
        if (this.articles != null && this.articles.size() > this.maxSize) {
            this.articles = this.articles.subList(0, this.maxSize);
        }
    }

    public List<QYArticle> getArticles() {
        return this.articles;
    }

    public void setArticles(List<QYArticle> articles) {
        this.articles = articles.size() > this.maxSize ? articles.subList(0, this.maxSize) : articles;
    }

    public void add(String title) {
        this.add(title, null, null, null);
    }

    public void add(String title, String url) {
        this.add(title, null, null, url);
    }

    public void add(String title, String picUrl, String url) {
        this.add(title, null, picUrl, url);
    }

    public void add(String title, String description, String picUrl, String url) {
        this.add(new QYArticle(title, description, picUrl, url));
    }

    public void add(QYArticle article) {
        if (this.articles.size() < this.maxSize) {
            this.articles.add(article);
        }
    }

    @Override
    public String toXml() {
        MessageBuilder mb = new MessageBuilder(super.toXml());
        mb.addData("MsgType", "news");
        mb.addTag("ArticleCount", String.valueOf(this.articles.size()));
        mb.append("<Articles>\n");
        for (QYArticle article : this.articles) {
            mb.append(article.toXml());
        }
        mb.append("</Articles>\n");
        mb.surroundWith("xml");
        return mb.toString();
    }
}

