/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.util;

import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetWorkCenter {
    public static final int CONNECT_TIMEOUT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(NetWorkCenter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private NetWorkCenter() {
        LOG.warn("Oh,my god!!!How do you call this method?!");
        LOG.warn("You shouldn't create me!!!");
        LOG.warn("Look my doc again!!!");
    }

    public static void post(String url, String paramData, ResponseCallback callback) {
        NetWorkCenter.post(url, paramData, null, callback);
    }

    public static BaseResponse post(String url, String paramData) {
        final BaseResponse[] response = new BaseResponse[]{null};
        NetWorkCenter.post(url, paramData, new ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    BaseResponse r = JSONUtil.toBean(resultJson, BaseResponse.class);
                    r.setErrmsg(resultJson);
                    response[0] = r;
                } else {
                    response[0] = new BaseResponse();
                    response[0].setErrcode(String.valueOf(resultCode));
                    response[0].setErrmsg("\u8bf7\u6c42\u5931\u8d25");
                }
            }
        });
        return response[0];
    }

    public static void post(String url, String paramData, List<File> fileList, ResponseCallback callback) {
        NetWorkCenter.doRequest(RequestMethod.POST, url, paramData, fileList, callback);
    }

    public static BaseResponse post(String url, String paramData, List<File> fileList) {
        final BaseResponse[] response = new BaseResponse[]{null};
        NetWorkCenter.post(url, paramData, fileList, new ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    BaseResponse r = JSONUtil.toBean(resultJson, BaseResponse.class);
                    if (StrUtil.isBlank(r.getErrcode())) {
                        r.setErrcode("0");
                    }
                    r.setErrmsg(resultJson);
                    response[0] = r;
                } else {
                    response[0] = new BaseResponse();
                    response[0].setErrcode(String.valueOf(resultCode));
                    response[0].setErrmsg("\u8bf7\u6c42\u5931\u8d25");
                }
            }
        });
        return response[0];
    }

    public static void get(String url, Map<String, String> paramMap, ResponseCallback callback) {
        String paramData = null;
        if (null != paramMap && !paramMap.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<String, String> param : paramMap.entrySet()) {
                buffer.append(param.getKey()).append("=").append(param.getValue()).append("&");
            }
            paramData = buffer.substring(0, buffer.length() - 1);
        }
        NetWorkCenter.doRequest(RequestMethod.GET, url, paramData, null, callback);
    }

    public static BaseResponse get(String url) {
        final BaseResponse[] response = new BaseResponse[]{null};
        NetWorkCenter.doRequest(RequestMethod.GET, url, null, null, new ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    BaseResponse r = JSONUtil.toBean(resultJson, BaseResponse.class);
                    if (StrUtil.isBlank(r.getErrcode())) {
                        r.setErrcode("0");
                    }
                    r.setErrmsg(resultJson);
                    response[0] = r;
                } else {
                    response[0] = new BaseResponse();
                    response[0].setErrcode(String.valueOf(resultCode));
                    response[0].setErrmsg("\u8bf7\u6c42\u5931\u8d25");
                }
            }
        });
        return response[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRequest(RequestMethod method, String url, String paramData, List<File> fileList, ResponseCallback callback) {
        if (null == url || url.isEmpty()) {
            LOG.warn("The url is null or empty!!You must give it to me!OK?");
            return;
        }
        boolean haveCallback = true;
        if (null == callback) {
            LOG.warn("--------------no callback block!--------------");
            haveCallback = false;
        }
        LOG.debug("-----------------\u8bf7\u6c42\u5730\u5740:{}-----------------", (Object)url);
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        HttpGet request = null;
        switch (method) {
            case GET: {
                String getUrl = url;
                if (null != paramData) {
                    getUrl = getUrl + "?" + paramData;
                }
                request = new HttpGet(getUrl);
                break;
            }
            case POST: {
                LOG.debug("\u8bf7\u6c42\u5165\u53c2:");
                LOG.debug(paramData);
                request = new HttpPost(url);
                if (null != fileList && !fileList.isEmpty()) {
                    LOG.debug("\u4e0a\u4f20\u6587\u4ef6...");
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    for (File file : fileList) {
                        if (file.isFile()) {
                            FileBody fb = new FileBody(file);
                            builder.addPart("media", (ContentBody)fb);
                            continue;
                        }
                        LOG.warn("The target '{}' not a file,please check and try again!", (Object)file.getPath());
                        return;
                    }
                    if (null != paramData) {
                        builder.addPart("description", (ContentBody)new StringBody(paramData, ContentType.APPLICATION_JSON));
                    }
                    ((HttpPost)request).setEntity(builder.build());
                    break;
                }
                if (null == paramData) break;
                StringEntity jsonEntity = new StringEntity(paramData, ContentType.APPLICATION_JSON);
                ((HttpPost)request).setEntity((HttpEntity)jsonEntity);
                break;
            }
            default: {
                LOG.warn("-----------------\u8bf7\u6c42\u7c7b\u578b:{} \u6682\u4e0d\u652f\u6301-----------------", (Object)method.toString());
            }
        }
        CloseableHttpResponse response = null;
        try {
            long start = System.currentTimeMillis();
            response = client.execute((HttpUriRequest)request);
            long time = System.currentTimeMillis() - start;
            LOG.debug("\u672c\u6b21\u8bf7\u6c42'{}'\u8017\u65f6:{}ms", (Object)url.substring(url.lastIndexOf("/") + 1, url.length()), (Object)time);
            int resultCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String resultJson = EntityUtils.toString((HttpEntity)entity, (Charset)UTF_8);
            if (200 == resultCode) {
                LOG.debug("-----------------\u8bf7\u6c42\u6210\u529f-----------------");
                LOG.debug("\u54cd\u5e94\u7ed3\u679c:");
                LOG.debug(resultJson);
                if (haveCallback) {
                    callback.onResponse(resultCode, resultJson);
                }
            } else if (haveCallback) {
                LOG.warn("-----------------\u8bf7\u6c42\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u7801:{}-----------------", (Object)resultCode);
                callback.onResponse(resultCode, resultJson);
            }
        }
        catch (ClientProtocolException e) {
            LOG.error("ClientProtocolException:", (Throwable)e);
            LOG.warn("-----------------\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:{}-----------------", (Object)e.toString());
            if (haveCallback) {
                callback.onResponse(500, e.toString());
            }
        }
        catch (IOException e) {
            LOG.error("IOException:", (Throwable)e);
            LOG.warn("-----------------\u8bf7\u6c42\u51fa\u73b0IO\u5f02\u5e38:{}-----------------", (Object)e.toString());
            if (haveCallback) {
                callback.onResponse(500, e.toString());
            }
        }
        catch (Exception e) {
            LOG.error("Exception:", (Throwable)e);
            LOG.warn("-----------------\u8bf7\u6c42\u51fa\u73b0\u5176\u4ed6\u5f02\u5e38:{}-----------------", (Object)e.toString());
            if (haveCallback) {
                callback.onResponse(500, e.toString());
            }
        }
        finally {
            if (null != request && !request.isAborted()) {
                request.abort();
            }
            HttpClientUtils.closeQuietly((HttpClient)client);
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
    }

    public static interface ResponseCallback {
        public void onResponse(int var1, String var2);
    }

    static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

