/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.io.IOException;
import java.nio.charset.Charset;
import jetbrick.bean.FieldInfo;
import jetbrick.bean.KlassInfo;
import jetbrick.template.parser.ast.AstStatement;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.template.runtime.JetWriter;
import jetbrick.util.JdkUtils;

public final class AstText
extends AstStatement {
    private String text;
    private volatile TextEncoder encoder;
    private int line;
    static final KlassInfo KLASS_STRING = KlassInfo.create(String.class);
    static final FieldInfo FIELD_STRING_VALUE = KLASS_STRING.getDeclaredField("value");
    static final FieldInfo FIELD_STRING_OFFSET = KLASS_STRING.getDeclaredField("offset");
    static final FieldInfo FIELD_STRING_COUNT = KLASS_STRING.getDeclaredField("count");

    public AstText(String text, int line) {
        this.text = text;
        this.line = line;
    }

    public String getText() {
        return this.text;
    }

    public int getLine() {
        return this.line;
    }

    protected boolean isEmpty() {
        return this.text == null || this.text.length() == 0;
    }

    protected void trimDirectiveWhitespaces(boolean trimLeft, boolean trimRight, boolean keepLeftNewLine) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        int len = this.text.length();
        int lpos = 0;
        boolean trimedNewLine = false;
        if (trimLeft) {
            for (int i = 0; i < len; ++i) {
                char c = this.text.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c == '\r') {
                    if (keepLeftNewLine) {
                        lpos = i;
                        break;
                    }
                    trimedNewLine = true;
                    int n = i + 1;
                    if (n < len && this.text.charAt(n) == '\n') {
                        lpos = n + 1;
                        break;
                    }
                    lpos = n;
                    break;
                }
                if (c != '\n') break;
                if (keepLeftNewLine) {
                    lpos = i;
                    break;
                }
                trimedNewLine = true;
                lpos = i + 1;
                break;
            }
        }
        int rpos = len;
        if (trimRight) {
            for (int i = len - 1; i >= 0; --i) {
                char c = this.text.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c != '\n' && c != '\r') break;
                rpos = i + 1;
                break;
            }
        }
        this.text = lpos < rpos ? this.text.substring(lpos, rpos) : null;
        if (trimedNewLine) {
            ++this.line;
        }
    }

    protected void trimDirectiveComments(boolean trimLeft, boolean trimRight, String prefix, String suffix) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        int text_len = this.text.length();
        int prefix_len = prefix.length();
        int suffix_len = suffix.length();
        int lpos = 0;
        if (trimLeft) {
            for (int i = 0; i < text_len; ++i) {
                char c = this.text.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                boolean matched = true;
                for (int j = 0; i < text_len && j < suffix_len; ++i, ++j) {
                    if (this.text.charAt(i) == suffix.charAt(j)) continue;
                    matched = false;
                    break;
                }
                if (!matched) break;
                lpos = i;
                break;
            }
        }
        int rpos = text_len;
        if (trimRight) {
            for (int i = text_len - 1; i >= 0; --i) {
                char c = this.text.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                boolean matched = true;
                for (int j = prefix_len - 1; i >= 0 && j >= 0; --i, --j) {
                    if (this.text.charAt(i) == prefix.charAt(j)) continue;
                    matched = false;
                    break;
                }
                if (!matched) break;
                rpos = i + 1;
                break;
            }
        }
        this.text = lpos < rpos ? this.text.substring(lpos, rpos) : null;
    }

    protected void trimLastNewLine() {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        int length = this.text.length();
        if (this.text.charAt(length - 1) == '\n' && --length > 0 && this.text.charAt(length - 1) == '\r') {
            --length;
        }
        this.text = this.text.substring(0, length);
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        JetWriter os = ctx.getWriter();
        if (this.encoder == null) {
            this.encoder = os.isStreaming() ? new ByteArrayEncoder(this.text, os.getCharset()) : (JdkUtils.IS_AT_LEAST_JAVA_7 ? new Jdk7CharArrayEncoder(this.text) : new Jdk6CharArrayEncoder(this.text));
            this.text = null;
        }
        try {
            this.encoder.writeTo(os);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.text;
    }

    static final class Jdk6CharArrayEncoder
    implements TextEncoder {
        final char[] chars;
        final int offset;
        final int count;

        public Jdk6CharArrayEncoder(String text) {
            this.chars = (char[])FIELD_STRING_VALUE.get((Object)text);
            this.offset = (Integer)FIELD_STRING_OFFSET.get((Object)text);
            this.count = (Integer)FIELD_STRING_COUNT.get((Object)text);
        }

        @Override
        public void writeTo(JetWriter os) throws IOException {
            os.print(this.chars, this.offset, this.count);
        }
    }

    static final class Jdk7CharArrayEncoder
    implements TextEncoder {
        final char[] chars;

        public Jdk7CharArrayEncoder(String text) {
            this.chars = (char[])FIELD_STRING_VALUE.get((Object)text);
        }

        @Override
        public void writeTo(JetWriter os) throws IOException {
            os.print(this.chars, 0, this.chars.length);
        }
    }

    static final class ByteArrayEncoder
    implements TextEncoder {
        private final byte[] bytes;

        public ByteArrayEncoder(String text, Charset charset) {
            this.bytes = text.getBytes(charset);
        }

        @Override
        public void writeTo(JetWriter os) throws IOException {
            os.print(this.bytes, 0, this.bytes.length);
        }
    }

    static interface TextEncoder {
        public void writeTo(JetWriter var1) throws IOException;
    }
}

