/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Map;
import jetbrick.template.Errors;
import jetbrick.template.JetGlobalContext;
import jetbrick.template.runtime.ValueContext;
import jetbrick.util.ClassUtils;

public final class ValueStack {
    private static final Object NULL = new Object();
    private static final int DEFAULT_CAPACITY = 8;
    private static final int UNUSED_INDEX = 0;
    private final JetGlobalContext globalContext;
    private final Map<String, Object> userContext;
    private ValueContext[] contexts;
    private int index;
    private ValueContext current;

    public ValueStack(JetGlobalContext globalContext, Map<String, Object> userContext) {
        this.globalContext = globalContext;
        this.userContext = userContext;
        this.contexts = new ValueContext[8];
        this.index = 0;
        this.current = null;
    }

    public void push(Map<String, Class<?>> symbols, Map<String, Object> privateContext, boolean inherited) {
        if (++this.index == this.contexts.length) {
            this.contexts = Arrays.copyOf(this.contexts, this.index + 8);
        }
        ValueContext parent = inherited ? this.current : null;
        this.current = this.contexts[this.index] = new ValueContext(parent, symbols, privateContext);
    }

    public void pop() {
        if (this.index == 0) {
            throw new EmptyStackException();
        }
        this.contexts[this.index--] = null;
        this.current = this.index == 0 ? null : this.contexts[this.index];
    }

    public Object getValue(String name) {
        if (this.index == 0) {
            throw new EmptyStackException();
        }
        Object value = this.current.getLocal(name);
        if (value != null) {
            return value == NULL ? null : value;
        }
        value = this.current.getPrivate(name);
        if (value != null) {
            this.current.setLocal(name, value);
            return value == NULL ? null : value;
        }
        if (this.userContext != null && (value = this.userContext.get(name)) != null) {
            this.current.setLocal(name, value);
            return value;
        }
        if (this.globalContext != null && (value = this.globalContext.getValue(name)) != null) {
            this.current.setLocal(name, value);
            return value;
        }
        return null;
    }

    public Class<?> getType(String name) {
        return this.doGetType(name, this.current, true);
    }

    private Class<?> doGetType(String name, ValueContext which, boolean fromInherited) {
        if (this.index == 0) {
            throw new EmptyStackException();
        }
        Class<?> type = which.getType(name, fromInherited);
        if (type != null) {
            return type;
        }
        if (fromInherited && this.globalContext != null) {
            return this.globalContext.getType(name);
        }
        return null;
    }

    public void setLocal(String name, Object value) throws IllegalStateException {
        if (this.index == 0) {
            throw new EmptyStackException();
        }
        if (value == null) {
            value = NULL;
        } else {
            Class<?> type = this.doGetType(name, this.current, false);
            if (type != null && !ClassUtils.isInstance(type, (Object)value)) {
                throw new IllegalStateException(Errors.format("inconsistent class for variable: `%s` is not %s", name, type.getName()));
            }
        }
        this.current.setLocal(name, value);
    }

    public void setSuper(String name, Object value) throws IllegalStateException {
        if (this.index == 0) {
            throw new EmptyStackException();
        }
        if (this.index == 1) {
            throw new IllegalStateException("no super");
        }
        ValueContext parent = this.contexts[this.index - 1];
        if (value == null) {
            value = NULL;
        } else {
            Class<?> type = this.doGetType(name, parent, false);
            if (type != null && !ClassUtils.isInstance(type, (Object)value)) {
                throw new IllegalStateException(Errors.format("inconsistent class for variable: `%s` is not %s", name, type.getName()));
            }
        }
        parent.setLocal(name, value);
    }
}

