/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.writer;

import java.io.IOException;
import java.io.OutputStream;
import jetbrick.template.runtime.OriginalStream;

public final class TrimLeadingWhitespacesOutputStream
extends OutputStream
implements OriginalStream {
    private final OutputStream out;
    private boolean first;

    public TrimLeadingWhitespacesOutputStream(OutputStream out) {
        this.out = out;
        this.first = true;
    }

    @Override
    public Object getOriginStream() {
        return this.out;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.first) {
            if (b <= 32) {
                return;
            }
            this.first = false;
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.first) {
            if (b == null) {
                throw new NullPointerException();
            }
            if ((off | len | b.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int max = off + len;
            while (off < max) {
                if (b[off] <= 32) {
                    ++off;
                    continue;
                }
                this.first = false;
                break;
            }
            if ((len = max - off) == 0) {
                return;
            }
        }
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

