/*
 * Decompiled with CFR 0.152.
 */
package com.github.wenhao.jpa;

import com.github.wenhao.jpa.specification.BetweenSpecification;
import com.github.wenhao.jpa.specification.EqualSpecification;
import com.github.wenhao.jpa.specification.GeSpecification;
import com.github.wenhao.jpa.specification.GtSpecification;
import com.github.wenhao.jpa.specification.InSpecification;
import com.github.wenhao.jpa.specification.LeSpecification;
import com.github.wenhao.jpa.specification.LikeSpecification;
import com.github.wenhao.jpa.specification.LtSpecification;
import com.github.wenhao.jpa.specification.NotEqualSpecification;
import com.github.wenhao.jpa.specification.NotInSpecification;
import com.github.wenhao.jpa.specification.NotLikeSpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;

public class PredicateBuilder<T> {
    private final Predicate.BooleanOperator operator;
    private List<Specification<T>> specifications;

    public PredicateBuilder(Predicate.BooleanOperator operator) {
        this.operator = operator;
        this.specifications = new ArrayList<Specification<T>>();
    }

    public PredicateBuilder<T> eq(String property, Object ... values) {
        return this.eq(true, property, values);
    }

    public PredicateBuilder<T> eq(boolean condition, String property, Object ... values) {
        return this.predicate(condition, new EqualSpecification(property, values));
    }

    public PredicateBuilder<T> ne(String property, Object ... values) {
        return this.ne(true, property, values);
    }

    public PredicateBuilder<T> ne(boolean condition, String property, Object ... values) {
        return this.predicate(condition, new NotEqualSpecification(property, values));
    }

    public PredicateBuilder<T> gt(String property, Comparable<?> compare) {
        return this.gt(true, property, compare);
    }

    public PredicateBuilder<T> gt(boolean condition, String property, Comparable<?> compare) {
        return this.predicate(condition, new GtSpecification(property, compare));
    }

    public PredicateBuilder<T> ge(String property, Comparable<?> compare) {
        return this.ge(true, property, compare);
    }

    public PredicateBuilder<T> ge(boolean condition, String property, Comparable<? extends Object> compare) {
        return this.predicate(condition, new GeSpecification(property, compare));
    }

    public PredicateBuilder<T> lt(String property, Comparable<?> number) {
        return this.lt(true, property, number);
    }

    public PredicateBuilder<T> lt(boolean condition, String property, Comparable<?> compare) {
        return this.predicate(condition, new LtSpecification(property, compare));
    }

    public PredicateBuilder<T> le(String property, Comparable<?> compare) {
        return this.le(true, property, compare);
    }

    public PredicateBuilder<T> le(boolean condition, String property, Comparable<?> compare) {
        return this.predicate(condition, new LeSpecification(property, compare));
    }

    public PredicateBuilder<T> between(String property, Object lower, Object upper) {
        return this.between(true, property, lower, upper);
    }

    public PredicateBuilder<T> between(boolean condition, String property, Object lower, Object upper) {
        return this.predicate(condition, new BetweenSpecification(property, lower, upper));
    }

    public PredicateBuilder<T> like(String property, String ... patterns) {
        return this.like(true, property, patterns);
    }

    public PredicateBuilder<T> like(boolean condition, String property, String ... patterns) {
        return this.predicate(condition, new LikeSpecification(property, patterns));
    }

    public PredicateBuilder<T> notLike(String property, String ... patterns) {
        return this.notLike(true, property, patterns);
    }

    public PredicateBuilder<T> notLike(boolean condition, String property, String ... patterns) {
        return this.predicate(condition, new NotLikeSpecification(property, patterns));
    }

    public PredicateBuilder<T> in(String property, Object ... values) {
        return this.in(true, property, values);
    }

    public PredicateBuilder<T> in(boolean condition, String property, Object ... values) {
        return this.predicate(condition, new InSpecification(property, values));
    }

    public PredicateBuilder<T> notIn(String property, Object ... values) {
        return this.notIn(true, property, values);
    }

    public PredicateBuilder<T> notIn(boolean condition, String property, Object ... values) {
        return this.predicate(condition, new NotInSpecification(property, values));
    }

    public PredicateBuilder<T> predicate(Specification specification) {
        return this.predicate(true, specification);
    }

    public PredicateBuilder<T> predicate(boolean condition, Specification specification) {
        if (condition) {
            this.specifications.add(specification);
        }
        return this;
    }

    public Specification<T> build() {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate[] predicates = new Predicate[this.specifications.size()];
            for (int i = 0; i < this.specifications.size(); ++i) {
                predicates[i] = this.specifications.get(i).toPredicate(root, query, cb);
            }
            if (Objects.equals(predicates.length, 0)) {
                return null;
            }
            return Predicate.BooleanOperator.OR.equals((Object)this.operator) ? cb.or(predicates) : cb.and(predicates);
        };
    }
}

