/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.AudioDataStream;
import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class SpeechSynthesisCancellationDetails {
    private CancellationReason reason;
    private String errorDetails;
    private CancellationErrorCode errorCode;

    public static SpeechSynthesisCancellationDetails fromResult(SpeechSynthesisResult speechSynthesisResult) {
        return new SpeechSynthesisCancellationDetails(speechSynthesisResult);
    }

    public static SpeechSynthesisCancellationDetails fromStream(AudioDataStream audioDataStream) {
        return new SpeechSynthesisCancellationDetails(audioDataStream);
    }

    private SpeechSynthesisCancellationDetails(SpeechSynthesisResult speechSynthesisResult) {
        Contracts.throwIfNull(speechSynthesisResult, "result");
        Contracts.throwIfNull(speechSynthesisResult.getImpl(), "resultHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReasonFromSynthResult(speechSynthesisResult.getImpl(), intRef));
        this.reason = CancellationReason.values()[(int)intRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCodeFromSynthResult(speechSynthesisResult.getImpl(), intRef));
        this.errorCode = CancellationErrorCode.values()[(int)intRef.getValue()];
        this.errorDetails = speechSynthesisResult.getProperties().getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    private SpeechSynthesisCancellationDetails(AudioDataStream audioDataStream) {
        Contracts.throwIfNull(audioDataStream, "stream");
        Contracts.throwIfNull(audioDataStream.getImpl(), "streamHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReasonFromStream(audioDataStream.getImpl(), intRef));
        this.reason = CancellationReason.values()[(int)intRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCodeFromStream(audioDataStream.getImpl(), intRef));
        this.errorCode = CancellationErrorCode.values()[(int)intRef.getValue()];
        this.errorDetails = audioDataStream.getProperties().getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    public void close() {
    }

    public CancellationReason getReason() {
        return this.reason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CancellationReason:" + (Object)((Object)this.reason) + " ErrorCode: " + (Object)((Object)this.errorCode) + " ErrorDetails:" + this.errorDetails;
    }

    private final native long getCanceledReasonFromSynthResult(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCodeFromSynthResult(SafeHandle var1, IntRef var2);

    private final native long getCanceledReasonFromStream(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCodeFromStream(SafeHandle var1, IntRef var2);
}

