/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.User;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class Conversation
implements AutoCloseable {
    private SafeHandle conversationHandle;
    private boolean disposed = false;
    private final Object conversationLock = new Object();
    private int activeAsyncConversationCounter = 0;
    private PropertyCollection propertyHandle;

    public static Future<Conversation> createConversationAsync(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        final SpeechConfig speechConfig2 = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Conversation>(){

            @Override
            public Conversation call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(Conversation.createConversationFromConfig(intRef, speechConfig2.getImpl(), ""));
                return new Conversation(intRef.getValue());
            }
        });
    }

    public static Future<Conversation> createConversationAsync(SpeechConfig speechConfig, String string) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(string, "conversationId");
        final String string2 = string;
        final SpeechConfig speechConfig2 = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Conversation>(){

            @Override
            public Conversation call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(Conversation.createConversationFromConfig(intRef, speechConfig2.getImpl(), string2));
                return new Conversation(intRef.getValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.conversationLock;
        synchronized (object) {
            if (this.activeAsyncConversationCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public String getConversationId() {
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getConversationId(this.conversationHandle, stringRef));
        return stringRef.getValue();
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Participant> addParticipantAsync(Participant participant) {
        final Participant participant2 = participant;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.addParticipant(Conversation.this.conversationHandle, participant2.getImpl()));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return participant2;
            }
        });
    }

    public Future<Participant> addParticipantAsync(final String string) {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                final Participant[] participantArray = new Participant[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Participant participant = Participant.from(string);
                        Contracts.throwIfFail(Conversation.this.addParticipant(Conversation.this.conversationHandle, participant.getImpl()));
                        participantArray[0] = participant;
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return participantArray[0];
            }
        });
    }

    public Future<User> addParticipantAsync(final User user) {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<User>(){

            @Override
            public User call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.addParticipantByUser(Conversation.this.conversationHandle, user.getImpl()));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return user;
            }
        });
    }

    public Future<Void> removeParticipantAsync(User user) {
        final User user2 = user;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipantByUser(Conversation.this.conversationHandle, user2.getImpl()));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(Participant participant) {
        final Participant participant2 = participant;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipant(Conversation.this.conversationHandle, participant2.getImpl()));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(String string) {
        final String string2 = string;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipantByUserId(Conversation.this.conversationHandle, string2));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> endConversationAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.endConversation(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startConversationAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.startConversation(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> deleteConversationAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.deleteConversation(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> lockConversationAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.lockConversation(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unlockConversationAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unlockConversation(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteAllParticipantsAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.muteAll(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteAllParticipantsAsync() {
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unmuteAll(Conversation.this.conversationHandle));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteParticipantAsync(String string) {
        final String string2 = string;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.muteParticipant(Conversation.this.conversationHandle, string2));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteParticipantAsync(String string) {
        final String string2 = string;
        final Conversation conversation = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unmuteParticipant(Conversation.this.conversationHandle, string2));
                    }
                };
                conversation.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public SafeHandle getImpl() {
        return this.conversationHandle;
    }

    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.conversationHandle != null) {
                this.conversationHandle.close();
                this.conversationHandle = null;
            }
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    protected Conversation(long l) {
        this.conversationHandle = new SafeHandle(l, SafeHandleType.Conversation);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.conversationHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncConversationAction(Runnable runnable) {
        Object object = this.conversationLock;
        synchronized (object) {
            ++this.activeAsyncConversationCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.conversationLock;
            synchronized (object) {
                --this.activeAsyncConversationCounter;
            }
        }
    }

    private static final native long createConversationFromConfig(IntRef var0, SafeHandle var1, String var2);

    private final native long getConversationId(SafeHandle var1, StringRef var2);

    private final native long addParticipant(SafeHandle var1, SafeHandle var2);

    private final native long addParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipant(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUserId(SafeHandle var1, String var2);

    private final native long startConversation(SafeHandle var1);

    private final native long endConversation(SafeHandle var1);

    private final native long deleteConversation(SafeHandle var1);

    private final native long lockConversation(SafeHandle var1);

    private final native long unlockConversation(SafeHandle var1);

    private final native long muteParticipant(SafeHandle var1, String var2);

    private final native long muteAll(SafeHandle var1);

    private final native long unmuteParticipant(SafeHandle var1, String var2);

    private final native long unmuteAll(SafeHandle var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);
}

