/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.mongodb.morphia;

import com.google.common.base.Function;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.mongodb.morphia.MorphiaSerializer;
import com.mysema.query.types.EntityPath;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.mapping.cache.DefaultEntityCache;
import org.mongodb.morphia.mapping.cache.EntityCache;

public class MorphiaQuery<K>
extends MongodbQuery<K> {
    private final EntityCache cache;
    private final Datastore datastore;

    public MorphiaQuery(Morphia morphia, Datastore datastore, EntityPath<K> entityPath) {
        this(morphia, datastore, (EntityCache)new DefaultEntityCache(), entityPath);
    }

    public MorphiaQuery(Morphia morphia, Datastore datastore, Class<? extends K> entityType) {
        this(morphia, datastore, (EntityCache)new DefaultEntityCache(), entityType);
    }

    public MorphiaQuery(Morphia morphia, Datastore datastore, EntityCache cache, EntityPath<K> entityPath) {
        this(morphia, datastore, cache, entityPath.getType());
    }

    public MorphiaQuery(final Morphia morphia, Datastore datastore, final EntityCache cache, final Class<? extends K> entityType) {
        super(datastore.getCollection(entityType), new Function<DBObject, K>(){

            public K apply(DBObject dbObject) {
                return morphia.fromDBObject(entityType, dbObject, cache);
            }
        }, new MorphiaSerializer(morphia));
        this.datastore = datastore;
        this.cache = cache;
    }

    @Override
    protected DBCursor createCursor() {
        this.cache.flush();
        return super.createCursor();
    }

    @Override
    protected DBCollection getCollection(Class<?> type) {
        return this.datastore.getCollection(type);
    }
}

