/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.impl.provider;

import com.robert.vesta.service.impl.provider.MachineIdProvider;
import com.robert.vesta.util.IpUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IpConfigurableMachineIdProvider
implements MachineIdProvider {
    private static final Logger log = LoggerFactory.getLogger(IpConfigurableMachineIdProvider.class);
    private long machineId;
    private Map<String, Long> ipsMap = new HashMap<String, Long>();

    public IpConfigurableMachineIdProvider() {
        log.debug("IpConfigurableMachineIdProvider constructed.");
    }

    public IpConfigurableMachineIdProvider(String ips) {
        this.setIps(ips);
        this.init();
    }

    public void init() {
        String ip = IpUtils.getHostIp();
        if (StringUtils.isEmpty((Object)ip)) {
            String msg = "Fail to get host IP address. Stop to initialize the IpConfigurableMachineIdProvider provider.";
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        if (!this.ipsMap.containsKey(ip)) {
            String msg = String.format("Fail to configure ID for host IP address %s. Stop to initialize the IpConfigurableMachineIdProvider provider.", ip);
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        this.machineId = this.ipsMap.get(ip);
        log.info("IpConfigurableMachineIdProvider.init ip {} id {}", (Object)ip, (Object)this.machineId);
    }

    public void setIps(String ips) {
        log.debug("IpConfigurableMachineIdProvider ips {}", (Object)ips);
        if (!StringUtils.isEmpty((Object)ips)) {
            String[] ipArray = ips.split(",");
            for (int i = 0; i < ipArray.length; ++i) {
                this.ipsMap.put(ipArray[i], Long.valueOf(i));
            }
        }
    }

    @Override
    public long getMachineId() {
        return this.machineId;
    }

    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }
}

