package com.wisdom.financial.constant;

/**
 * @author paranoia
 */
public interface ApiConstant {

    String SETTLEMENT = "/api/finSettlementCenter";

    /**
     * 生成上传结算中心联系单数据接口地址
     */
    String GENERATE_FINANCIAL_SETTLEMENT_DATA = SETTLEMENT + "/saveSettlementData";

    /**
     * 撤销联系单上传接口地址
     */
    String REVERT_SETTLEMENT_UPLOAD = SETTLEMENT + "/revertSettlementData";

    String PAYMENT = "/api/finPaymentCenter";

    /**
     * 财务收付款确认接口地址
     */
    String CONFIRM_PAYMENT = PAYMENT + "/confirmPayment";

    /**
     * 撤销财务收付款确认接口地址
     */
    String CANCEL_PAYMENT = PAYMENT + "/revertPayment";

    String MONTH_END = "/month";

    /**
     *  生成月末结转账单数据接口地址
     */
    String GENERATE_FINANCIAL_ORDER_DATA = MONTH_END + "/generateFinancialOrderData";

    /**
     *  上传月末结转账单数据后更新上传标记接口地址
     */
    String UPDATE_ORDER_UPLOAD_FLAG = MONTH_END + "/updateOrderUploadFlag";

    String INVOICE = "/invoice";

    /**
     *  添加同步发票信息接口地址
     */
    String SYNC_INVOICE_DATA = INVOICE + "/syncInvoiceData";

    /**
     * 交互方式——RPC
     */
    String INTERACT_MODE_RPC="RPC";

    /**
     * 交互方式——HTTP
     */
    String INTERACT_MODE_HTTP="HTTP";

}
