package com.wisdom.financial.domain.constants;

/**
 * 政治面貌
 */
public enum SettlementTypeEnum {
    IMPORT_ORDER("4", "进口换单"),
    INSURANCE("7", "保险费"),
    SECURITY_DEPOSIT("10", "保证金"),
    IMPORT_CHARGES("11", "进口杂费"),
    IMPORT_DEPOSIT("12", "进口押金"),
    REFUND("14", "退款"),
    TARIFF("16", "关税"),
    SHIPOWNER_FEE("20", "船东运杂费"),
    STATION_FEE("21", "场站费"),
    LAND_FREIGHT("22", "陆运费"),
    CUSTOMS_FEES("23", "报关报验费");

    private String code;
    private String name;

    SettlementTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 根据name 返回对应的 code
     * @param name name
     * @return String
     */
    public static String getCodeByName(String name) {
        String code = "";
        if (IMPORT_ORDER.getName().equals(name)) {
            code = IMPORT_ORDER.getCode();
        }
        if (INSURANCE.getName().equals(name)) {
            code = INSURANCE.getCode();
        }
        if (SECURITY_DEPOSIT.getName().equals(name)) {
            code = SECURITY_DEPOSIT.getCode();
        }
        if (IMPORT_CHARGES.getName().equals(name)) {
            code = IMPORT_CHARGES.getCode();
        }
        if (IMPORT_DEPOSIT.getName().equals(name)) {
            code = IMPORT_DEPOSIT.getCode();
        }
        if (REFUND.getName().equals(name)) {
            code = REFUND.getCode();
        }
        if (TARIFF.getName().equals(name)) {
            code = TARIFF.getCode();
        }
        if (SHIPOWNER_FEE.getName().equals(name)) {
            code = SHIPOWNER_FEE.getCode();
        }
        if (STATION_FEE.getName().equals(name)) {
            code = STATION_FEE.getCode();
        }
        if (LAND_FREIGHT.getName().equals(name)) {
            code = LAND_FREIGHT.getCode();
        }
        if (CUSTOMS_FEES.getName().equals(name)) {
            code = CUSTOMS_FEES.getCode();
        }
        return code;
    }

    /**
     * 根据code返回对应的 name
     * @param code code
     * @return String
     */
    public static String getNameByCode(String code) {
        String name = "";
        if (IMPORT_ORDER.getCode().equals(code)) {
            name = IMPORT_ORDER.getName();
        }
        if (INSURANCE.getCode().equals(code)) {
            name = INSURANCE.getName();
        }
        if (SECURITY_DEPOSIT.getCode().equals(code)) {
            name = SECURITY_DEPOSIT.getName();
        }
        if (IMPORT_CHARGES.getCode().equals(code)) {
            name = IMPORT_CHARGES.getName();
        }
        if (IMPORT_DEPOSIT.getCode().equals(code)) {
            name = IMPORT_DEPOSIT.getName();
        }
        if (REFUND.getCode().equals(code)) {
            name = REFUND.getName();
        }
        if (TARIFF.getCode().equals(code)) {
            name = TARIFF.getName();
        }
        if (SHIPOWNER_FEE.getCode().equals(code)) {
            name = SHIPOWNER_FEE.getName();
        }
        if (STATION_FEE.getCode().equals(code)) {
            name = STATION_FEE.getName();
        }
        if (LAND_FREIGHT.getCode().equals(code)) {
            name = LAND_FREIGHT.getName();
        }
        if (CUSTOMS_FEES.getCode().equals(code)) {
            name = CUSTOMS_FEES.getName();
        }
        return name;
    }
}
