package com.wisdom.financial.domain.dto;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @author derrick.yang
 * @version v1.0
 *          <p>返回结果类</p>
 */

public class ApiResult implements Serializable {
    /**
     * 返回值
     */
    private int returnCode = 200;
    /**
     * 提示信息
     */
    private String returnMsg = "操作成功";
    /**
     * 返回数据
     */
    private Object returnData = new HashMap<String,Object>();

    /**
     * 构造方法
     * @param returnData 返回实体类结构
     */
    public ApiResult(Object returnData) {
        this.returnMsg = "操作成功";
        this.returnData = returnData;
    }

    public ApiResult(int returnCode, String returnMsg) {
        this.returnCode = returnCode;
        this.returnMsg = returnMsg;
    }

    public ApiResult(int returnCode, String returnMsg, Object returnData) {
        this.returnCode = returnCode;
        this.returnMsg = returnMsg;
        this.returnData = returnData;
    }

	public ApiResult() {
		super();
	}

	public int getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public Object getReturnData() {
        return returnData;
    }

    public void setReturnData(Object returnData) {
        this.returnData = returnData;
    }

    @Override
    public String toString() {
        return "Result{" + "returnCode=" + returnCode + ", returnMsg='" + returnMsg + '\'' + ", " +
                "returnData=" + returnData + '}';
    }
}
