package com.wisdom.financial.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 业务汇总表 数据结构
 * @author paranoia
 */
@ApiModel(value = "业务汇总")
public class FinancialBusinessInfoDTO implements Serializable {

    @ApiModelProperty(value = "id")
    private String id;

    /**
     *  业务系统注册ID
     */
    @ApiModelProperty(value = "业务系统注册ID")
    private Integer osbid;

    /**
     *  业务系统业务流水号
     *  必填 业务系统需保证唯一性
     */
    @ApiModelProperty(value = "业务系统业务流水号")
    private String orderNo;

    /**
     *  业务类型
     *  必填
     */
    @ApiModelProperty(value = "业务类型")
    private String businessType;

    /**
     *  业务属性
     *  必填
     */
    @ApiModelProperty(value = "业务属性")
    private String businessAttr;

    /**
     *  主提单号
     *
     */
    @ApiModelProperty(value = "主提单号")
    private String mainOrderNo;

    /**
     *  分提单号
     *
     */
    @ApiModelProperty(value = "分提单号")
    private String singleOrderNo;

    /**
     *  箱号
     */
    @ApiModelProperty(value = "箱号")
    private String containerNo;

    /**
     *  主单标志
     */
    @ApiModelProperty(value = "主单标志")
    private String mainOrderFlag;

    /**
     *  船公司代码
     */
    @ApiModelProperty(value = "船公司代码")
    private String shippingCompanyCode;

    /**
     *  委托客户代码
     */
    @ApiModelProperty(value = "委托客户代码")
    private String delegationCustomerCode;

    /**
     *  场站代码
     */
    @ApiModelProperty(value = "场站代码")
    private String loadStationCode;

    /**
     * 船名
     */
    @ApiModelProperty(value = "船名")
    private String vessel;

    /**
     * 航次
     */
    @ApiModelProperty(value = "航次")
    private String voyage;

    /**
     * 业务日期
     * 必填
     * 业务实际发生日期
     * 货代：离港日
     * 陆运：运单实际完结时间
     */
    @ApiModelProperty(value = "业务日期 业务实际发生日期  货代：离港日  陆运：运单实际完结时间")
    private String businessDate;

    /**
     * 装货港代码
     */
    @ApiModelProperty(value = "装货港代码")
    private String loadCode;

    /**
     * 装货港名称
     */
    @ApiModelProperty(value = "装货港名称")
    private String loadPort;

    /**
     * 目的港代码
     */
    @ApiModelProperty(value = "目的港代码")
    private String destinationPortCode;

    /**
     *  箱量20 数量
     */
    @ApiModelProperty(value = "箱量20 数量")
    private Integer x20;

    /**
     *  箱量40 数量
     */
    @ApiModelProperty(value = "箱量40 数量")
    private Integer x40;

    /**
     *  箱量45 数量
     */
    @ApiModelProperty(value = "箱量45 数量")
    private Integer x45;

    /**
     *  制单部门
     */
    @ApiModelProperty(value = "制单部门")
    private Integer depart;

    /**
     * 录入人ID
     */
    @ApiModelProperty(value = "制单人")
    private Integer createdBy;

    /**
     *  制单日期
     */
    @ApiModelProperty(value = "制单日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getOsbid() {
        return osbid;
    }

    public void setOsbid(Integer osbid) {
        this.osbid = osbid;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessAttr() {
        return businessAttr;
    }

    public void setBusinessAttr(String businessAttr) {
        this.businessAttr = businessAttr;
    }

    public String getMainOrderNo() {
        return mainOrderNo;
    }

    public void setMainOrderNo(String mainOrderNo) {
        this.mainOrderNo = mainOrderNo;
    }

    public String getSingleOrderNo() {
        return singleOrderNo;
    }

    public void setSingleOrderNo(String singleOrderNo) {
        this.singleOrderNo = singleOrderNo;
    }

    public String getMainOrderFlag() {
        return mainOrderFlag;
    }

    public void setMainOrderFlag(String mainOrderFlag) {
        this.mainOrderFlag = mainOrderFlag;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getDelegationCustomerCode() {
        return delegationCustomerCode;
    }

    public void setDelegationCustomerCode(String delegationCustomerCode) {
        this.delegationCustomerCode = delegationCustomerCode;
    }

    public String getLoadStationCode() {
        return loadStationCode;
    }

    public void setLoadStationCode(String loadStationCode) {
        this.loadStationCode = loadStationCode;
    }

    public String getVessel() {
        return vessel;
    }

    public void setVessel(String vessel) {
        this.vessel = vessel;
    }

    public String getVoyage() {
        return voyage;
    }

    public void setVoyage(String voyage) {
        this.voyage = voyage;
    }

    public String getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(String businessDate) {
        this.businessDate = businessDate;
    }

    public String getLoadCode() {
        return loadCode;
    }

    public void setLoadCode(String loadCode) {
        this.loadCode = loadCode;
    }

    public String getLoadPort() {
        return loadPort;
    }

    public void setLoadPort(String loadPort) {
        this.loadPort = loadPort;
    }

    public String getDestinationPortCode() {
        return destinationPortCode;
    }

    public void setDestinationPortCode(String destinationPortCode) {
        this.destinationPortCode = destinationPortCode;
    }

    public Integer getX20() {
        return x20;
    }

    public void setX20(Integer x20) {
        this.x20 = x20;
    }

    public Integer getX40() {
        return x40;
    }

    public void setX40(Integer x40) {
        this.x40 = x40;
    }

    public Integer getX45() {
        return x45;
    }

    public void setX45(Integer x45) {
        this.x45 = x45;
    }

    public Integer getDepart() {
        return depart;
    }

    public void setDepart(Integer depart) {
        this.depart = depart;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getContainerNo() {
        return containerNo;
    }

    public void setContainerNo(String containerNo) {
        this.containerNo = containerNo;
    }

    public Integer getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public FinancialBusinessInfoDTO() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialBusinessInfoDTO)) {
            return false;
        }

        FinancialBusinessInfoDTO that = (FinancialBusinessInfoDTO) o;

        return new EqualsBuilder()
                .append(getOrderNo(), that.getOrderNo())
                .append(getBusinessType(), that.getBusinessType())
                .append(getBusinessAttr(), that.getBusinessAttr())
                .append(getMainOrderNo(), that.getMainOrderNo())
                .append(getSingleOrderNo(), that.getSingleOrderNo())
                .append(getMainOrderFlag(), that.getMainOrderFlag())
                .append(getShippingCompanyCode(), that.getShippingCompanyCode())
                .append(getDelegationCustomerCode(), that.getDelegationCustomerCode())
                .append(getLoadStationCode(), that.getLoadStationCode())
                .append(getVessel(), that.getVessel())
                .append(getVoyage(), that.getVoyage())
                .append(getBusinessDate(), that.getBusinessDate())
                .append(getLoadCode(), that.getLoadCode())
                .append(getLoadPort(), that.getLoadPort())
                .append(getDestinationPortCode(), that.getDestinationPortCode())
                .append(getX20(), that.getX20())
                .append(getX40(), that.getX40())
                .append(getX45(), that.getX45())
                .append(getDepart(), that.getDepart())
                .append(getCreatedBy(), that.getCreatedBy())
                .append(getCreatedTime(), that.getCreatedTime())
                .append(getContainerNo(), that.getContainerNo())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getOrderNo())
                .append(getBusinessType())
                .append(getBusinessAttr())
                .append(getMainOrderNo())
                .append(getSingleOrderNo())
                .append(getMainOrderFlag())
                .append(getShippingCompanyCode())
                .append(getDelegationCustomerCode())
                .append(getLoadStationCode())
                .append(getVessel())
                .append(getVoyage())
                .append(getBusinessDate())
                .append(getLoadCode())
                .append(getLoadPort())
                .append(getDestinationPortCode())
                .append(getX20())
                .append(getX40())
                .append(getX45())
                .append(getDepart())
                .append(getCreatedBy())
                .append(getCreatedTime())
                .append(getContainerNo())
                .toHashCode();
    }
}
