package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * @author paranoia
 */
@ApiModel(value = "发票抬头信息，销货方和购货方")
public class FinancialInvoiceBaseInfo {

    /**
     * 购货方名称
     */
    @ApiModelProperty(value = "购货方名称")
    private String buyerName;

    /**
     * 购货方税号
     */
    @ApiModelProperty(value = "购货方税号")
    private String buyerTaxCode;

    /**
     * 购货方地址电话
     */
    @ApiModelProperty(value = "购货方地址电话")
    private String buyerAddress;

    /**
     * 购货方开户行及账号
     */
    @ApiModelProperty(value = "购货方开户行及账号")
    private String buyerBankAccount;

    /**
     * 销货方名称
     */
    @ApiModelProperty(value = "销货方名称")
    private String salesName;

    /**
     * 销货方税号
     */
    @ApiModelProperty(value = "销货方税号")
    private String salesTaxCode;

    /**
     * 销货方地址电话
     */
    @ApiModelProperty(value = "销货方地址电话")
    private String salesAddress;

    /**
     * 销货方开户行及账号
     */
    @ApiModelProperty(value = "销货方开户行及账号")
    private String salesBankAccount;

    public FinancialInvoiceBaseInfo() {
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getBuyerTaxCode() {
        return buyerTaxCode;
    }

    public void setBuyerTaxCode(String buyerTaxCode) {
        this.buyerTaxCode = buyerTaxCode;
    }

    public String getBuyerAddress() {
        return buyerAddress;
    }

    public void setBuyerAddress(String buyerAddress) {
        this.buyerAddress = buyerAddress;
    }

    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }

    public String getSalesName() {
        return salesName;
    }

    public void setSalesName(String salesName) {
        this.salesName = salesName;
    }

    public String getSalesTaxCode() {
        return salesTaxCode;
    }

    public void setSalesTaxCode(String salesTaxCode) {
        this.salesTaxCode = salesTaxCode;
    }

    public String getSalesAddress() {
        return salesAddress;
    }

    public void setSalesAddress(String salesAddress) {
        this.salesAddress = salesAddress;
    }

    public String getSalesBankAccount() {
        return salesBankAccount;
    }

    public void setSalesBankAccount(String salesBankAccount) {
        this.salesBankAccount = salesBankAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialInvoiceBaseInfo)) {
            return false;
        }

        FinancialInvoiceBaseInfo that = (FinancialInvoiceBaseInfo) o;

        return new EqualsBuilder().append(getBuyerName(), that.getBuyerName())
                .append(getBuyerTaxCode(), that.getBuyerTaxCode())
                .append(getBuyerAddress(), that.getBuyerAddress())
                .append(getBuyerBankAccount(), that.getBuyerBankAccount())
                .append(getSalesName(), that.getSalesName())
                .append(getSalesTaxCode(), that.getSalesTaxCode())
                .append(getSalesAddress(), that.getSalesAddress())
                .append(getSalesBankAccount(), that.getSalesBankAccount())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getBuyerName())
                .append(getBuyerTaxCode())
                .append(getBuyerAddress())
                .append(getBuyerBankAccount())
                .append(getSalesName())
                .append(getSalesTaxCode())
                .append(getSalesAddress())
                .append(getSalesBankAccount())
                .toHashCode();
    }
}
