package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 财务结算中心发票信息
 */
@ApiModel(value = "财务结算中心发票信息")
public class FinancialInvoiceDTO implements Serializable {

    /**
     * 发票id
     */
    @ApiModelProperty(value = "发票id")
    private Long pjid;

    @ApiModelProperty(value = "业务系统Id")
    private Integer osbid;

    /**
     *  发票代码 15位代码
     */
    @ApiModelProperty(value = "发票代码  15位代码")
    private String fpdm;

    /**
     *  发票号码
     */
    @ApiModelProperty(value = "发票号码")
    private String fpno;

    /**
     *  开票种类 ZC-正常 YJ-预借
     */
    @ApiModelProperty(value = "开票种类 ZC-正常 YJ-预借")
    private String fpzl;

    /**
     *  发票类别
     */
    @ApiModelProperty(value = "发票类别")
    private String fplb;

    /**
     *  发票税率
     */
    @ApiModelProperty(value = "发票税率")
    private BigDecimal fpsl;

    /**
     *  发票日期
     */
    @ApiModelProperty(value = "发票日期")
    private String fprq;

    /**
     *  发票抬头
     */
    @ApiModelProperty(value = "发票抬头")
    private String fptt;

    /**
     *  税号
     */
    @ApiModelProperty(value = "税号")
    private String sh;

    /**
     *  地址
     */
    @ApiModelProperty(value = "地址")
    private String addr;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String tele;

    /**
     *  开户信息
     */
    @ApiModelProperty(value = "开户信息")
    private String khxx;

    /**
     *  发票币种
     */
    @ApiModelProperty(value = "发票币种")
    private String fpbz;

    /**
     *  外币汇率
     */
    @ApiModelProperty(value = "外币汇率")
    private BigDecimal wbhl;

    /**
     *  发票原币金额
     */
    @ApiModelProperty(value = "发票原币金额")
    private BigDecimal ysje;

    /**
     *  发票票面金额
     */
    @ApiModelProperty(value = "发票票面金额")
    private BigDecimal fpje;

    /**
     *  发票备注
     */
    @ApiModelProperty(value = "发票备注")
    private String note;

    /**
     * 开票人id
     */
    @ApiModelProperty(value = "开票人id")
    private Integer lryid;

    /**
     * 复核人id
     */
    @ApiModelProperty(value = "复核人id")
    private Integer fhrid;

    /**
     *  经手人id
     */
    @ApiModelProperty(value = "经手人id")
    private Integer jsrid;

    /**
     *  业务部门
     */
    @ApiModelProperty(value = "业务部门")
    private Integer bmbm;

    /**
     *  核销标志
     */
    @ApiModelProperty(value = "核销标志")
    private String hxbz;

    /**
     *  作废标志
     */
    @ApiModelProperty(value = "作废标志")
    private String zfbz;

    /**
     *  红冲发票号，互相记录对应的发票id
     */
    @ApiModelProperty(value = "红冲发票号，互相记录对应的发票id")
    private Long zffpid;

    /**
     * 开票日期
     */
    @ApiModelProperty(value = "开票日期")
    private Date kprq;

    /**
     *  发票来源
     */
    @ApiModelProperty(value = "发票来源")
    private String fply;

    /**
     *  客户签收图编号
     */
    @ApiModelProperty(value = "客户签收图编号")
    private Long docid;

    /**
     *  领用人id
     */
    @ApiModelProperty(value = "领用人id")
    private Integer lyrid;

    /**
     *  领用人名称
     */
    @ApiModelProperty(value = "领用人名称")
    private String lyrmc;

    /**
     *  领用日期
     */
    @ApiModelProperty(value = "领用日期")
    private Date lyrq;

    /**
     *  发票入账标识
     */
    @ApiModelProperty(value = "发票入账标识")
    private String rzbs;

    /**
     *  电子发票 1 = 电子发票 0 = 纸质发票
     */
    @ApiModelProperty(value = "电子发票 1 = 电子发票 0 = 纸质发票")
    private String dzfp;

    /**
     *  电子发票地址
     */
    @ApiModelProperty(value = "电子发票地址")
    private String dzfpurl;

    /**
     *  0生成   1-正在开票    2-开票成功    3-开票失败   4开始红冲    5-红冲成功    6-红中失败
     */
    @ApiModelProperty(value = "0生成   1-正在开票    2-开票成功    3-开票失败   4开始红冲    5-红冲成功    6-红中失败")
    private String pid;

    /**
     * 发票提取码
     */
    @ApiModelProperty(value = "发票提取码")
    private String fptqm;

    /**
     * 发票开具失败描述
     */
    @ApiModelProperty(value = "发票开具失败描述")
    private String dzfperr;

    /**
     * 该电子发票已经被上传 当dzfp='1'有效
     */
    @ApiModelProperty(value = "发票开具失败描述")
    private String upload;

    /**
     * 银行账户   原KHXX存开户行和账号因打印进账单无法分开,故单独设置
     */
    @ApiModelProperty(value = "银行账户")
    private String yhzh;

    /**
     * 电票短信通知接收手机号
     */
    @ApiModelProperty(value = "电票短信通知接收手机号")
    private String smsno;

    @ApiModelProperty(value = "发票详情集合")
    private List<FinancialInvoiceDetailDTO> financialInvoiceDetailList;

    public FinancialInvoiceDTO() {
    }

    public Long getPjid() {
        return pjid;
    }

    public void setPjid(Long pjid) {
        this.pjid = pjid;
    }

    public Integer getOsbid() {
        return osbid;
    }

    public void setOsbid(Integer osbid) {
        this.osbid = osbid;
    }

    public String getFpdm() {
        return fpdm;
    }

    public void setFpdm(String fpdm) {
        this.fpdm = fpdm;
    }

    public String getFpno() {
        return fpno;
    }

    public void setFpno(String fpno) {
        this.fpno = fpno;
    }

    public String getFpzl() {
        return fpzl;
    }

    public void setFpzl(String fpzl) {
        this.fpzl = fpzl;
    }

    public String getFplb() {
        return fplb;
    }

    public void setFplb(String fplb) {
        this.fplb = fplb;
    }

    public BigDecimal getFpsl() {
        return fpsl;
    }

    public void setFpsl(BigDecimal fpsl) {
        this.fpsl = fpsl;
    }

    public String getFprq() {
        return fprq;
    }

    public void setFprq(String fprq) {
        this.fprq = fprq;
    }

    public String getFptt() {
        return fptt;
    }

    public void setFptt(String fptt) {
        this.fptt = fptt;
    }

    public String getSh() {
        return sh;
    }

    public void setSh(String sh) {
        this.sh = sh;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getKhxx() {
        return khxx;
    }

    public void setKhxx(String khxx) {
        this.khxx = khxx;
    }

    public String getFpbz() {
        return fpbz;
    }

    public void setFpbz(String fpbz) {
        this.fpbz = fpbz;
    }

    public BigDecimal getWbhl() {
        return wbhl;
    }

    public void setWbhl(BigDecimal wbhl) {
        this.wbhl = wbhl;
    }

    public BigDecimal getYsje() {
        return ysje;
    }

    public void setYsje(BigDecimal ysje) {
        this.ysje = ysje;
    }

    public BigDecimal getFpje() {
        return fpje;
    }

    public void setFpje(BigDecimal fpje) {
        this.fpje = fpje;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getLryid() {
        return lryid;
    }

    public void setLryid(Integer lryid) {
        this.lryid = lryid;
    }

    public Integer getFhrid() {
        return fhrid;
    }

    public void setFhrid(Integer fhrid) {
        this.fhrid = fhrid;
    }

    public Integer getJsrid() {
        return jsrid;
    }

    public void setJsrid(Integer jsrid) {
        this.jsrid = jsrid;
    }

    public Integer getBmbm() {
        return bmbm;
    }

    public void setBmbm(Integer bmbm) {
        this.bmbm = bmbm;
    }

    public String getHxbz() {
        return hxbz;
    }

    public void setHxbz(String hxbz) {
        this.hxbz = hxbz;
    }

    public String getZfbz() {
        return zfbz;
    }

    public void setZfbz(String zfbz) {
        this.zfbz = zfbz;
    }

    public Long getZffpid() {
        return zffpid;
    }

    public void setZffpid(Long zffpid) {
        this.zffpid = zffpid;
    }

    public Date getKprq() {
        return kprq;
    }

    public void setKprq(Date kprq) {
        this.kprq = kprq;
    }

    public String getFply() {
        return fply;
    }

    public void setFply(String fply) {
        this.fply = fply;
    }

    public Long getDocid() {
        return docid;
    }

    public void setDocid(Long docid) {
        this.docid = docid;
    }

    public Integer getLyrid() {
        return lyrid;
    }

    public void setLyrid(Integer lyrid) {
        this.lyrid = lyrid;
    }

    public String getLyrmc() {
        return lyrmc;
    }

    public void setLyrmc(String lyrmc) {
        this.lyrmc = lyrmc;
    }

    public Date getLyrq() {
        return lyrq;
    }

    public void setLyrq(Date lyrq) {
        this.lyrq = lyrq;
    }

    public String getRzbs() {
        return rzbs;
    }

    public void setRzbs(String rzbs) {
        this.rzbs = rzbs;
    }

    public String getDzfp() {
        return dzfp;
    }

    public void setDzfp(String dzfp) {
        this.dzfp = dzfp;
    }

    public String getDzfpurl() {
        return dzfpurl;
    }

    public void setDzfpurl(String dzfpurl) {
        this.dzfpurl = dzfpurl;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getFptqm() {
        return fptqm;
    }

    public void setFptqm(String fptqm) {
        this.fptqm = fptqm;
    }

    public String getDzfperr() {
        return dzfperr;
    }

    public void setDzfperr(String dzfperr) {
        this.dzfperr = dzfperr;
    }

    public String getUpload() {
        return upload;
    }

    public void setUpload(String upload) {
        this.upload = upload;
    }

    public String getTele() {
        return tele;
    }

    public void setTele(String tele) {
        this.tele = tele;
    }

    public String getYhzh() {
        return yhzh;
    }

    public void setYhzh(String yhzh) {
        this.yhzh = yhzh;
    }

    public String getSmsno() {
        return smsno;
    }

    public void setSmsno(String smsno) {
        this.smsno = smsno;
    }

    public List<FinancialInvoiceDetailDTO> getFinancialInvoiceDetailList() {
        return financialInvoiceDetailList;
    }

    public void setFinancialInvoiceDetailList(List<FinancialInvoiceDetailDTO> financialInvoiceDetailList) {
        this.financialInvoiceDetailList = financialInvoiceDetailList;
    }
}
