package com.wisdom.financial.domain.dto;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

public class FinancialInvoiceDetailDTO implements Serializable {

    private Long id;

    /**
     * 发票/票据流水号
     */
    private Long pjid;

    /**
     * 发票项目
     */
    private String fpxm;

    /**
     * 发票金额
     */
    private BigDecimal je;

    public FinancialInvoiceDetailDTO() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialInvoiceDetailDTO)) {
            return false;
        }

        FinancialInvoiceDetailDTO that = (FinancialInvoiceDetailDTO) o;

        return new EqualsBuilder()
                .append(getId(), that.getId())
                .append(getPjid(), that.getPjid())
                .append(getFpxm(), that.getFpxm())
                .append(getJe(), that.getJe())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getId())
                .append(getPjid())
                .append(getFpxm())
                .append(getJe())
                .toHashCode();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPjid() {
        return pjid;
    }

    public void setPjid(Long pjid) {
        this.pjid = pjid;
    }

    public String getFpxm() {
        return fpxm;
    }

    public void setFpxm(String fpxm) {
        this.fpxm = fpxm;
    }

    public BigDecimal getJe() {
        return je;
    }

    public void setJe(BigDecimal je) {
        this.je = je;
    }
}
