package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * 发票通知人
 * @author paranoia
 */
@ApiModel(value = "发票通知人")
public class FinancialInvoiceNotifierDTO {
    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人")
    private String lxr;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String mail;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String tele;

    public FinancialInvoiceNotifierDTO() {
    }

    public String getLxr() {
        return lxr;
    }

    public void setLxr(String lxr) {
        this.lxr = lxr;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getTele() {
        return tele;
    }

    public void setTele(String tele) {
        this.tele = tele;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialInvoiceNotifierDTO)) {
            return false;
        }

        FinancialInvoiceNotifierDTO that = (FinancialInvoiceNotifierDTO) o;

        return new EqualsBuilder()
                .append(getLxr(), that.getLxr())
                .append(getMail(), that.getMail())
                .append(getTele(), that.getTele())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getLxr())
                .append(getMail())
                .append(getTele()).toHashCode();
    }
}
