package com.wisdom.financial.domain.dto;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author paranoia
 */
@ApiModel(value = "账单汇总")
public class FinancialOrderDTO implements Serializable {
    /**
     * 账单号 f_get_new_id('charge_id')
     */
    @ApiModelProperty(value = "账单号")
    private String chargeId;

    /**
     * sz_os osbid
     */
    @ApiModelProperty(value = "业务系统注册号")
    private Integer registerCompanyId;

    /**
     *  业务系统上传账单号
     *  必填
     */
    @ApiModelProperty(value = "业务系统 上传账单号")
    private String billNo;

    /**
     * 业务id
     */
    @ApiModelProperty(value = "业务id")
    private String orderId;

    /**
     * 业务系统流水号
     * 必填
     */
    @ApiModelProperty(value = "业务系统 流水号")
    private String orderNo;

    /**
     * 业务类型
     * 必填
     *
     * 对应 businessType
     */
    @ApiModelProperty(value = "业务类型")
    private String businessType;

    /**
     * 业务属性 DC 订舱 QD = 签单 CD = 舱单 关联 cd_para attr = ywsx
     *
     * 对应 businessAttr
     */
    @ApiModelProperty(value = "业务属性")
    private String businessAttr;

    /**
     * 揽货人
     */
    @ApiModelProperty(value = "揽货人")
    private Integer canvasserId;

    /**
     * 商务人id
     */
    @ApiModelProperty(value = "商务人id")
    private Integer swrid;

    /**
     * 结算方式 MD YJ
     *
     * 对应settlementMethod
     */
    @ApiModelProperty(value = "结算方式")
    private String settlementMethod;

    /**
     * 冲销标志(B=被冲账单 / R=红冲账单)
     */
    @ApiModelProperty(value = "冲销标志")
    private String writeOffFlag;

    /**
     * 红冲对应billdh
     */
    @ApiModelProperty(value = "红冲对应billdh")
    private String writeOffChargeId;

    /**
     * 上传到账单交换系统的单号
     */
    @ApiModelProperty(value = "上传到账单交换系统的单号")
    private Long chargeSwapId;

    /**
     * 转账id
     */
    @ApiModelProperty(value = "转账id")
    private Long bankTransferId;

    /**
     * 转账标记
     */
    @ApiModelProperty(value = "转账标记")
    private String bankTransferFlag;

    /**
     * 转账日期
     */
    @ApiModelProperty(value = "转账日期")
    private String bankTransferDate;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 制单人
     * 必填
     */
    @ApiModelProperty(value = "制单人")
    private Integer createdBy;

    /**
     * 账单归属部门
     * 必填
     *
     */
    @ApiModelProperty(value = "账单归属部门")
    private Integer createDept;

    /**
     * 制单日期
     */
    @ApiModelProperty(value = "制单日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

    /**
     * 从业务系统上传日期
     * 必填
     */
    @ApiModelProperty(value = "从业务系统上传日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date uploadTime;

    /**
     * 业务类型
     *
     */
    @ApiModelProperty(value = "业务类型")
    private String fllb;

    /**
     * 合计借金额
     */
    @ApiModelProperty(value = "合计借金额")
    private BigDecimal standardAmountReceivable;

    /**
     * 合计贷金额
     */
    @ApiModelProperty(value = "合计贷金额")
    private BigDecimal standardAmountPayable;

    @ApiModelProperty(value = "实收实付金额")
    private BigDecimal amountReceipt;

    @ApiModelProperty(value = "MD5")
    private String md5;

    public FinancialOrderDTO() {
    }

    public String getChargeId() {
        return chargeId;
    }

    public void setChargeId(String chargeId) {
        this.chargeId = chargeId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getRegisterCompanyId() {
        return registerCompanyId;
    }

    public void setRegisterCompanyId(Integer registerCompanyId) {
        this.registerCompanyId = registerCompanyId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getSwrid() {
        return swrid;
    }

    public void setSwrid(Integer swrid) {
        this.swrid = swrid;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getFllb() {
        return fllb;
    }

    public void setFllb(String fllb) {
        this.fllb = fllb;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessAttr() {
        return businessAttr;
    }

    public void setBusinessAttr(String businessAttr) {
        this.businessAttr = businessAttr;
    }

    public Integer getCanvasserId() {
        return canvasserId;
    }

    public void setCanvasserId(Integer canvasserId) {
        this.canvasserId = canvasserId;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public String getWriteOffFlag() {
        return writeOffFlag;
    }

    public void setWriteOffFlag(String writeOffFlag) {
        this.writeOffFlag = writeOffFlag;
    }

    public String getWriteOffChargeId() {
        return writeOffChargeId;
    }

    public void setWriteOffChargeId(String writeOffChargeId) {
        this.writeOffChargeId = writeOffChargeId;
    }

    public Long getChargeSwapId() {
        return chargeSwapId;
    }

    public void setChargeSwapId(Long chargeSwapId) {
        this.chargeSwapId = chargeSwapId;
    }

    public Long getBankTransferId() {
        return bankTransferId;
    }

    public void setBankTransferId(Long bankTransferId) {
        this.bankTransferId = bankTransferId;
    }

    public String getBankTransferFlag() {
        return bankTransferFlag;
    }

    public void setBankTransferFlag(String bankTransferFlag) {
        this.bankTransferFlag = bankTransferFlag;
    }

    public String getBankTransferDate() {
        return bankTransferDate;
    }

    public void setBankTransferDate(String bankTransferDate) {
        this.bankTransferDate = bankTransferDate;
    }

    public Integer getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public Integer getCreateDept() {
        return createDept;
    }

    public void setCreateDept(Integer createDept) {
        this.createDept = createDept;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getUploadTime() {
        return uploadTime;
    }

    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }

    public BigDecimal getStandardAmountReceivable() {
        return standardAmountReceivable;
    }

    public void setStandardAmountReceivable(BigDecimal standardAmountReceivable) {
        this.standardAmountReceivable = standardAmountReceivable;
    }

    public BigDecimal getStandardAmountPayable() {
        return standardAmountPayable;
    }

    public void setStandardAmountPayable(BigDecimal standardAmountPayable) {
        this.standardAmountPayable = standardAmountPayable;
    }

    public BigDecimal getAmountReceipt() {
        return amountReceipt;
    }

    public void setAmountReceipt(BigDecimal amountReceipt) {
        this.amountReceipt = amountReceipt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FinancialOrderDTO that = (FinancialOrderDTO) o;
        return Objects.equals(chargeId, that.chargeId) &&
                Objects.equals(registerCompanyId, that.registerCompanyId) &&
                Objects.equals(billNo, that.billNo) &&
                Objects.equals(orderId, that.orderId) &&
                Objects.equals(orderNo, that.orderNo) &&
                Objects.equals(businessType, that.businessType) &&
                Objects.equals(businessAttr, that.businessAttr) &&
                Objects.equals(canvasserId, that.canvasserId) &&
                Objects.equals(swrid, that.swrid) &&
                Objects.equals(settlementMethod, that.settlementMethod) &&
                Objects.equals(writeOffFlag, that.writeOffFlag) &&
                Objects.equals(writeOffChargeId, that.writeOffChargeId) &&
                Objects.equals(chargeSwapId, that.chargeSwapId) &&
                Objects.equals(bankTransferId, that.bankTransferId) &&
                Objects.equals(bankTransferFlag, that.bankTransferFlag) &&
                Objects.equals(bankTransferDate, that.bankTransferDate) &&
                Objects.equals(note, that.note) &&
                Objects.equals(createdBy, that.createdBy) &&
                Objects.equals(createDept, that.createDept) &&
                Objects.equals(createdTime, that.createdTime) &&
                Objects.equals(uploadTime, that.uploadTime) &&
                Objects.equals(fllb, that.fllb) &&
                Objects.equals(standardAmountReceivable, that.standardAmountReceivable) &&
                Objects.equals(standardAmountPayable, that.standardAmountPayable) &&
                Objects.equals(md5, that.md5);
    }

    @Override
    public int hashCode() {
        return Objects.hash(chargeId, registerCompanyId, billNo, orderId, orderNo, businessType, businessAttr, canvasserId, swrid, settlementMethod, writeOffFlag, writeOffChargeId, chargeSwapId, bankTransferId, bankTransferFlag, bankTransferDate, note, createdBy, createDept, createdTime, uploadTime, fllb, standardAmountReceivable, standardAmountPayable, md5);
    }

    @Override
    public String toString() {
        return "FinancialOrderDTO{" +
                "chargeId=" + chargeId +
                ", registerCompanyId=" + registerCompanyId +
                ", billNo='" + billNo + '\'' +
                ", orderId=" + orderId +
                ", orderNo='" + orderNo + '\'' +
                ", businessType='" + businessType + '\'' +
                ", businessAttr='" + businessAttr + '\'' +
                ", canvasserId=" + canvasserId +
                ", swrid=" + swrid +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", writeOffFlag='" + writeOffFlag + '\'' +
                ", writeOffChargeId='" + writeOffChargeId + '\'' +
                ", chargeSwapId=" + chargeSwapId +
                ", bankTransferId=" + bankTransferId +
                ", bankTransferFlag='" + bankTransferFlag + '\'' +
                ", bankTransferDate='" + bankTransferDate + '\'' +
                ", note='" + note + '\'' +
                ", createdBy=" + createdBy +
                ", createDept=" + createDept +
                ", createdTime=" + createdTime +
                ", uploadTime=" + uploadTime +
                ", fllb='" + fllb + '\'' +
                ", standardAmountReceivable=" + standardAmountReceivable +
                ", standardAmountPayable=" + standardAmountPayable +
                ", md5='" + md5 + '\'' +
                '}';
    }
}
