package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 月末结转账单数据上传时校验数据是否一致。
 * @author paranoia
 */
@ApiModel("月末结转账单数据上传时校验类")
public class FinancialOrderDetailCheckDTO implements Serializable {

    /**
     * 账单明细id
     */
    @ApiModelProperty(value = "账单明细id")
    private String billId;

    /**
     * 账单汇总id
     */
    @ApiModelProperty(value = "账单汇总id")
    private String billNo;

    /**
     * 费种id
     */
    @ApiModelProperty(value = "费种id")
    private Integer feeId;

    /**
     * 外币币种
     */
    @ApiModelProperty(value = "外币币种")
    private String currency;

    /**
     * 外币汇率
     */
    @ApiModelProperty(value = "外币汇率")
    private BigDecimal exchangeRate;

    /**
     * 借金额
     */
    @ApiModelProperty(value = "借金额")
    private BigDecimal amountReceivable;

    /**
     * 贷金额
     */
    @ApiModelProperty(value = "贷金额")
    private BigDecimal amountPayable;

    /**
     * 客户编码 统一浪潮代码
     */
    @ApiModelProperty(value = "客户编码 统一浪潮代码")
    private String customerCode;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "md5")
    private String md5;

    public FinancialOrderDetailCheckDTO() {
    }

    public String getBillId() {
        return billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Integer getFeeId() {
        return feeId;
    }

    public void setFeeId(Integer feeId) {
        this.feeId = feeId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public BigDecimal getAmountReceivable() {
        return amountReceivable;
    }

    public void setAmountReceivable(BigDecimal amountReceivable) {
        this.amountReceivable = amountReceivable;
    }

    public BigDecimal getAmountPayable() {
        return amountPayable;
    }

    public void setAmountPayable(BigDecimal amountPayable) {
        this.amountPayable = amountPayable;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        FinancialOrderDetailCheckDTO that = (FinancialOrderDetailCheckDTO) o;

        return new EqualsBuilder()
                .append(billId, that.billId)
                .append(billNo, that.billNo)
                .append(feeId, that.feeId)
                .append(currency, that.currency)
                .append(exchangeRate, that.exchangeRate)
                .append(amountReceivable, that.amountReceivable)
                .append(amountPayable, that.amountPayable)
                .append(customerCode, that.customerCode)
                .append(invoiceType, that.invoiceType)
                .append(md5, that.md5)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(billId)
                .append(billNo)
                .append(feeId)
                .append(currency)
                .append(exchangeRate)
                .append(amountReceivable)
                .append(amountPayable)
                .append(customerCode)
                .append(invoiceType)
                .append(md5)
                .toHashCode();
    }

    @Override
    public String toString() {
        return "FinancialOrderDetailCheckDTO{" +
                "billId='" + billId + '\'' +
                ", billNo='" + billNo + '\'' +
                ", feeId=" + feeId +
                ", currency='" + currency + '\'' +
                ", exchangeRate=" + exchangeRate +
                ", amountReceivable=" + amountReceivable +
                ", amountPayable=" + amountPayable +
                ", customerCode='" + customerCode + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", md5='" + md5 + '\'' +
                '}';
    }
}
