package com.wisdom.financial.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "账单明细")
public class FinancialOrderDetailDTO implements Serializable {
    /**
     * 财务明细号 f_get_new_id('charge_detail_id')
     */
    @ApiModelProperty(value = "财务明细号")
    private String chargeDetailId;

    /**
     * 账单汇总id  对应财务结算中心账单汇总id
     */
    @ApiModelProperty(value = "账单汇总id")
    private String chargeId;

    /**
     *  业务系统账单明细id
     *  必填
     */
    @ApiModelProperty(value = "业务系统账单明细id")
    private Long billId;

    /**
     *  业务系统账单号
     *  必填
     */
    @ApiModelProperty(value = "业务系统账单号")
    private String billNo;

    /**
     * 业务id
     */
    @ApiModelProperty(value = "业务id")
    private String orderId;

    /**
     * 业务系统 业务单号
     * 必填
     */
    @ApiModelProperty(value = "业务系统 业务单号")
    private String orderNo;

    /**
     * 费种id
     * 必填 对照后的结算中心费种代码
     *
     * 使用getCenterFeeCode(feeList, finBillDetail.getFeeCode())设置
     */
    @ApiModelProperty(value = "费种id")
    private Integer feeId;

    /**
     * 外币币种
     * 必填
     */
    @ApiModelProperty(value = "外币币种")
    private String currency;

    /**
     * 外币汇率
     * 必填
     */
    @ApiModelProperty(value = "外币汇率")
    private BigDecimal exchangeRate;

    /**
     * 应收金额
     * 必填 应收应付金额不能同时存在，其中一个值不能为零
     */
    @ApiModelProperty(value = "应收金额")
    private BigDecimal amountReceivable;

    /**
     * 应付金额
     * 必填 应收应付金额不能同时存在，其中一个值不能为零
     */
    @ApiModelProperty(value = "应付金额")
    private BigDecimal amountPayable;

    /**
     * 往来类型
     */
    @ApiModelProperty(value = "往来类型")
    private String innerType;

    /**
     * 内部往来明细id
     */
    @ApiModelProperty(value = "内部往来明细id")
    private Long swapId;

    /**
     * 客户编码 统一浪潮代码
     * 必填
     */
    @ApiModelProperty(value = "客户编码 统一浪潮代码")
    private String customerCode;

    /**
     * 制单人id
     * 必填
     */
    @ApiModelProperty(value = "制单人id")
    private Integer createdBy;

    /**
     * 制单日期
     * 必填
     */
    @ApiModelProperty(value = "制单日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

    /**
     * 应结费的截止日期
     */
    @ApiModelProperty(value = "应结费的截止日期")
    private String chargeClosingDate;

    /**
     * 系统id
     */
    @ApiModelProperty(value = "系统id")
    private Integer registerCompanyId;

    @ApiModelProperty(value = "md5")
    private String md5;

    /**
     *  财务结算中心数据写入时 insertOrUpdate 1= insert 2 = update
     */
    @ApiModelProperty(value = "财务结算中心数据写入时 insertOrUpdate 1= insert 2 = update")
    private Integer insertOrUpdate;

    /**
     *  结费方式
     */
    @ApiModelProperty(value = "结费方式")
    private String settlementMethod;

    /**
     *  发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "实收实付金额")
    private BigDecimal amountReceipt;

    @ApiModelProperty(value = "合计本位币应收")
    private BigDecimal standardAmountReceivable;

    @ApiModelProperty(value = "合计本位币应付")
    private BigDecimal standardAmountPayable;

    public FinancialOrderDetailDTO() {
    }

    public String getChargeDetailId() {
        return chargeDetailId;
    }

    public void setChargeDetailId(String chargeDetailId) {
        this.chargeDetailId = chargeDetailId;
    }

    public String getChargeId() {
        return chargeId;
    }

    public void setChargeId(String chargeId) {
        this.chargeId = chargeId;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getFeeId() {
        return feeId;
    }

    public void setFeeId(Integer feeId) {
        this.feeId = feeId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public BigDecimal getAmountReceivable() {
        return amountReceivable;
    }

    public void setAmountReceivable(BigDecimal amountReceivable) {
        this.amountReceivable = amountReceivable;
    }

    public BigDecimal getAmountPayable() {
        return amountPayable;
    }

    public void setAmountPayable(BigDecimal amountPayable) {
        this.amountPayable = amountPayable;
    }

    public String getInnerType() {
        return innerType;
    }

    public void setInnerType(String innerType) {
        this.innerType = innerType;
    }

    public Long getSwapId() {
        return swapId;
    }

    public void setSwapId(Long swapId) {
        this.swapId = swapId;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public Integer getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getChargeClosingDate() {
        return chargeClosingDate;
    }

    public void setChargeClosingDate(String chargeClosingDate) {
        this.chargeClosingDate = chargeClosingDate;
    }

    public Integer getRegisterCompanyId() {
        return registerCompanyId;
    }

    public void setRegisterCompanyId(Integer registerCompanyId) {
        this.registerCompanyId = registerCompanyId;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Integer getInsertOrUpdate() {
        return insertOrUpdate;
    }

    public void setInsertOrUpdate(Integer insertOrUpdate) {
        this.insertOrUpdate = insertOrUpdate;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public BigDecimal getStandardAmountReceivable() {
        return standardAmountReceivable;
    }

    public void setStandardAmountReceivable(BigDecimal standardAmountReceivable) {
        this.standardAmountReceivable = standardAmountReceivable;
    }

    public BigDecimal getStandardAmountPayable() {
        return standardAmountPayable;
    }

    public void setStandardAmountPayable(BigDecimal standardAmountPayable) {
        this.standardAmountPayable = standardAmountPayable;
    }

    public BigDecimal getAmountReceipt() {
        return amountReceipt;
    }

    public void setAmountReceipt(BigDecimal amountReceipt) {
        this.amountReceipt = amountReceipt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        FinancialOrderDetailDTO that = (FinancialOrderDetailDTO) o;

        return new EqualsBuilder()
                .append(chargeDetailId, that.chargeDetailId)
                .append(chargeId, that.chargeId)
                .append(billId, that.billId)
                .append(billNo, that.billNo)
                .append(orderId, that.orderId)
                .append(orderNo, that.orderNo)
                .append(feeId, that.feeId)
                .append(currency, that.currency)
                .append(exchangeRate, that.exchangeRate)
                .append(amountReceivable, that.amountReceivable)
                .append(amountPayable, that.amountPayable)
                .append(innerType, that.innerType)
                .append(swapId, that.swapId)
                .append(customerCode, that.customerCode)
                .append(createdBy, that.createdBy)
                .append(createdTime, that.createdTime)
                .append(chargeClosingDate, that.chargeClosingDate)
                .append(registerCompanyId, that.registerCompanyId)
                .append(md5, that.md5)
                .append(insertOrUpdate, that.insertOrUpdate)
                .append(settlementMethod, that.settlementMethod)
                .append(invoiceType, that.invoiceType)
                .append(standardAmountReceivable, that.standardAmountReceivable)
                .append(standardAmountPayable, that.standardAmountPayable)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(chargeDetailId)
                .append(chargeId)
                .append(billId)
                .append(billNo)
                .append(orderId)
                .append(orderNo)
                .append(feeId)
                .append(currency)
                .append(exchangeRate)
                .append(amountReceivable)
                .append(amountPayable)
                .append(innerType)
                .append(swapId)
                .append(customerCode)
                .append(createdBy)
                .append(createdTime)
                .append(chargeClosingDate)
                .append(registerCompanyId)
                .append(md5)
                .append(insertOrUpdate)
                .append(settlementMethod)
                .append(invoiceType)
                .append(standardAmountReceivable)
                .append(standardAmountPayable)
                .toHashCode();
    }
}
