package com.wisdom.financial.domain.dto;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class FinancialPaymentDTO implements Serializable {
    /**
     * 财务结算单号
     */
    private Long cwdh;

    /**
     * 业务系统财务结算单号
     */
    private String ywcwdh;

    /**
     * 业务板块代码（NB货代\CD船代\YS海运）
     */
    private Integer osbid;

    /**
     * 单位编号对应浪潮组织架构
     */
    private String dwbh;

    /**
     * 对应客户代码（浪潮代码）
     */
    private String khbm;

    /**
     * 结算性质 1- 收费结算 2- 付费结算
     */
    private String jsxz;

    /**
     * 结费方式
     */
    private Integer jsfsid;

    /**
     * 结费方式 业务数据库原有结费方式值 用于对照
     */
    private String settlementType;

    /**
     *  财务结算中心联系单号
     */
    private Long jsdh;

    /**
     *  业务系统联系单号
     */
    private String ywjsdh;

    /**
     * 结算日期
     */
    private String jsrq;

    /**
     * 币种
     */
    private String jsbz;

    /**
     * 结算汇率
     */
    private BigDecimal jshl;

    /**
     * 结算金额
     */
    private BigDecimal jsje;

    /**
     * 汇兑损益
     */
    private BigDecimal hdsy;

    /**
     * 银行手续费
     */
    private BigDecimal yhsxf;

    /**
     * 单据号
     */
    private String djh;

    /**
     * 业务部门
     */
    private Integer ywbm;

    private String zzrq;

    private BigDecimal zzid;

    /**
     * 备注
     */
    private String note;

    /**
     * 录入员
     */
    private Integer lryid;

    /**
     * 录入日期
     */
    private Date lrrq;

    private String fplx;

    public FinancialPaymentDTO() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialPaymentDTO)) {
            return false;
        }

        FinancialPaymentDTO that = (FinancialPaymentDTO) o;

        return new EqualsBuilder()
                .append(getCwdh(), that.getCwdh())
                .append(getYwcwdh(), that.getYwcwdh())
                .append(getOsbid(), that.getOsbid())
                .append(getDwbh(), that.getDwbh())
                .append(getKhbm(), that.getKhbm())
                .append(getJsxz(), that.getJsxz())
                .append(getJsfsid(), that.getJsfsid())
                .append(getSettlementType(), that.getSettlementType())
                .append(getJsdh(), that.getJsdh())
                .append(getJsrq(), that.getJsrq())
                .append(getJsbz(), that.getJsbz())
                .append(getJshl(), that.getJshl())
                .append(getJsje(), that.getJsje())
                .append(getHdsy(), that.getHdsy())
                .append(getYhsxf(), that.getYhsxf())
                .append(getDjh(), that.getDjh())
                .append(getYwbm(), that.getYwbm())
                .append(getZzrq(), that.getZzrq())
                .append(getZzid(), that.getZzid())
                .append(getNote(), that.getNote())
                .append(getLryid(), that.getLryid())
                .append(getLrrq(), that.getLrrq())
                .append(getFplx(), that.getFplx())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getCwdh())
                .append(getYwcwdh())
                .append(getOsbid())
                .append(getDwbh())
                .append(getKhbm())
                .append(getJsxz())
                .append(getJsfsid())
                .append(getSettlementType())
                .append(getJsdh())
                .append(getJsrq())
                .append(getJsbz())
                .append(getJshl())
                .append(getJsje())
                .append(getHdsy())
                .append(getYhsxf())
                .append(getDjh())
                .append(getYwbm())
                .append(getZzrq())
                .append(getZzid())
                .append(getNote())
                .append(getLryid())
                .append(getLrrq())
                .append(getFplx())
                .toHashCode();
    }

    public String getYwjsdh() {
        return ywjsdh;
    }

    public void setYwjsdh(String ywjsdh) {
        this.ywjsdh = ywjsdh;
    }

    public Long getCwdh() {
        return cwdh;
    }

    public void setCwdh(Long cwdh) {
        this.cwdh = cwdh;
    }

    public String getYwcwdh() {
        return ywcwdh;
    }

    public void setYwcwdh(String ywcwdh) {
        this.ywcwdh = ywcwdh;
    }

    public Integer getOsbid() {
        return osbid;
    }

    public void setOsbid(Integer osbid) {
        this.osbid = osbid;
    }

    public String getDwbh() {
        return dwbh;
    }

    public void setDwbh(String dwbh) {
        this.dwbh = dwbh;
    }

    public String getKhbm() {
        return khbm;
    }

    public void setKhbm(String khbm) {
        this.khbm = khbm;
    }

    public String getJsxz() {
        return jsxz;
    }

    public void setJsxz(String jsxz) {
        this.jsxz = jsxz;
    }

    public Integer getJsfsid() {
        return jsfsid;
    }

    public void setJsfsid(Integer jsfsid) {
        this.jsfsid = jsfsid;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public Long getJsdh() {
        return jsdh;
    }

    public void setJsdh(Long jsdh) {
        this.jsdh = jsdh;
    }

    public String getJsrq() {
        return jsrq;
    }

    public void setJsrq(String jsrq) {
        this.jsrq = jsrq;
    }

    public String getJsbz() {
        return jsbz;
    }

    public void setJsbz(String jsbz) {
        this.jsbz = jsbz;
    }

    public BigDecimal getJshl() {
        return jshl;
    }

    public void setJshl(BigDecimal jshl) {
        this.jshl = jshl;
    }

    public BigDecimal getJsje() {
        return jsje;
    }

    public void setJsje(BigDecimal jsje) {
        this.jsje = jsje;
    }

    public BigDecimal getHdsy() {
        return hdsy;
    }

    public void setHdsy(BigDecimal hdsy) {
        this.hdsy = hdsy;
    }

    public BigDecimal getYhsxf() {
        return yhsxf;
    }

    public void setYhsxf(BigDecimal yhsxf) {
        this.yhsxf = yhsxf;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public Integer getYwbm() {
        return ywbm;
    }

    public void setYwbm(Integer ywbm) {
        this.ywbm = ywbm;
    }

    public String getZzrq() {
        return zzrq;
    }

    public void setZzrq(String zzrq) {
        this.zzrq = zzrq;
    }

    public BigDecimal getZzid() {
        return zzid;
    }

    public void setZzid(BigDecimal zzid) {
        this.zzid = zzid;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getLryid() {
        return lryid;
    }

    public void setLryid(Integer lryid) {
        this.lryid = lryid;
    }

    public Date getLrrq() {
        return lrrq;
    }

    public void setLrrq(Date lrrq) {
        this.lrrq = lrrq;
    }

    public String getFplx() {
        return fplx;
    }

    public void setFplx(String fplx) {
        this.fplx = fplx;
    }
}