package com.wisdom.financial.domain.dto;


import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

public class FinancialPaymentDetailDTO implements Serializable {
    private Long cwid;

    private Long orderId;
    /**
     * 财务实收实付单号
     */
    private Long cwdh;

    private Long chargeDetailId;

    /**
     * 费种代码
     */
    private Integer feeid;

    /**
     * 费种代码 用于对照
     */
    private String feeCode;

    /**
     * 币种
     */
    private String wbbz;

    /**
     * 汇率
     */
    private BigDecimal wbhl;

    /**
     * 实收实付金额
     */
    private BigDecimal sfje;

    /**
     * 业务系统业务流水号
     */
    private String orderNo;

    private String ywlx;

    public FinancialPaymentDetailDTO() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof FinancialPaymentDetailDTO)) {
            return false;
        }

        FinancialPaymentDetailDTO that = (FinancialPaymentDetailDTO) o;

        return new EqualsBuilder()
                .append(getCwid(), that.getCwid())
                .append(getOrderId(), that.getOrderId())
                .append(getCwdh(), that.getCwdh())
                .append(getChargeDetailId(), that.getChargeDetailId())
                .append(getFeeid(), that.getFeeid())
                .append(getFeeCode(), that.getFeeCode())
                .append(getWbbz(), that.getWbbz())
                .append(getWbhl(), that.getWbhl())
                .append(getSfje(), that.getSfje())
                .append(getOrderNo(), that.getOrderNo())
                .append(getYwlx(), that.getYwlx())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getCwid())
                .append(getOrderId())
                .append(getCwdh())
                .append(getChargeDetailId())
                .append(getFeeid())
                .append(getFeeCode())
                .append(getWbbz())
                .append(getWbhl())
                .append(getSfje())
                .append(getOrderNo())
                .append(getYwlx())
                .toHashCode();
    }

    public Long getCwid() {
        return cwid;
    }

    public void setCwid(Long cwid) {
        this.cwid = cwid;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getCwdh() {
        return cwdh;
    }

    public void setCwdh(Long cwdh) {
        this.cwdh = cwdh;
    }

    public Long getChargeDetailId() {
        return chargeDetailId;
    }

    public void setChargeDetailId(Long chargeDetailId) {
        this.chargeDetailId = chargeDetailId;
    }

    public Integer getFeeid() {
        return feeid;
    }

    public void setFeeid(Integer feeid) {
        this.feeid = feeid;
    }

    public String getFeeCode() {
        return feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getWbbz() {
        return wbbz;
    }

    public void setWbbz(String wbbz) {
        this.wbbz = wbbz;
    }

    public BigDecimal getWbhl() {
        return wbhl;
    }

    public void setWbhl(BigDecimal wbhl) {
        this.wbhl = wbhl;
    }

    public BigDecimal getSfje() {
        return sfje;
    }

    public void setSfje(BigDecimal sfje) {
        this.sfje = sfje;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getYwlx() {
        return ywlx;
    }

    public void setYwlx(String ywlx) {
        this.ywlx = ywlx;
    }
}