package com.wisdom.financial.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 财务结算中心联系单数据上传结构
 * @author paranoia
 */
@ApiModel(value = "财务结算中心联系单数据上传结构")
public class FinancialSettlementDTO implements Serializable, Cloneable {

    /**
     * 结算单号
     */
    @ApiModelProperty(value = "结算单号")
    private Long settlementId;

    /**
     *  业务系统结算单号
     *  必填
     */
    @ApiModelProperty(value = "业务系统结算单号")
    private String settlementCode;

    @ApiModelProperty(value = "jsdhc")
    private String centerSettlementCode;

    /**
     *  业务系统注册号
     */
    @ApiModelProperty(value = "业务系统注册号")
    private Integer registerCompanyId;

    /**
     *  客户浪潮财务代码
     *  必填
     */
    @ApiModelProperty(value = "客户浪潮财务代码")
    private String customerCode;

    /**
     *  结算性质
     *  必填
     *  1：收费
     *  2：付费
     */
    @ApiModelProperty(value = "结算性质  1:收费  2：付费")
    private String settlementType;

    /**
     *  结算方式id
     *  必填
     *  1：现金
     *  2：支票
     *  3：网银
     *  4：电汇
     *  5：汇票
     *  6：抵付
     *  7：内部结算
     *  8：境外
     *  99：其他
     */
    @ApiModelProperty(value = "结算方式id")
    private Integer settlementModeId;

    /**
     *  结算用途
     */
    @ApiModelProperty(value = "结算用途")
    private String settlementPurposeName;

    /**
     *  结算币种
     *  必填
     *  RMB: 人民币
     *  USD：美金
     */
    @ApiModelProperty(value = "结算币种  RMB:人民币  USD:美金")
    private String currency;

    /**
     *  结算汇率
     *  必填
     */
    @ApiModelProperty(value = "结算汇率")
    private BigDecimal exchangeRate;

    /**
     *  结算金额
     *  必填
     */
    @ApiModelProperty(value = "结算金额")
    private BigDecimal amount;

    /**
     * 汇兑损益
     */
    @ApiModelProperty(value = "汇兑损益")
    private BigDecimal exchangeLossAmount;

    /**
     *  发票抬头
     *  必填
     */
    @ApiModelProperty(value = "发票抬头")
    private String invoiceTitle;

    /**
     *  发票类型 可以通过接口获取 /api/finCenter/invoiceType/getAll
     *  必填
     *  LY,0.0900,9%普票,9%普票
     *  NO,0.0000,原单原转,无票
     *  P0,0.0000,零税普票,零票
     *  PP,0.0600,6%普票,6%普票
     *  Z1,0.0100,1%专票,1%专票
     *  Z3,0.1300,13%专票,13%专票
     *  Z9,0.0900,9%专票,9%专票
     *  ZP,0.0600,6%专票,6%专票
     */
    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    /**
     * 客户税号
     */
    private String customerTaxCode;

    private String customerAddress;

    private String customerPhone;

    private String customerBankName;

    private String customerBankAccount;

    private String invoiceReceiverName;

    private String invoiceReviewerName;

    private String note;

    /**
     *  部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private Integer departCode;

    /**
     *  联系单制单人
     */
    @ApiModelProperty(value = "联系单制单人")
    private Integer createdBy;

    /**
     *  联系单制单日期
     */
    @ApiModelProperty(value = "联系单制单日期")
    private Date createdTime;

    /**
     * 1=拒绝   2=已开发票   3=红冲发票    4=已付款   5=已落实收
     *
     *  对应website_status
     */
    @ApiModelProperty(value = "1=拒绝   2=已开发票   3=红冲发票    4=已付款   5=已落实收")
    private String upzt;

    /**
     * 1=成功开具    2=申请开具   3=发票开具中  4=开具异常(用于本地开票)
     *
     * 对应invoice_status
     */
    @ApiModelProperty(value = "1=成功开具  2=申请开具   3=发票开具中  4=开具异常(用于本地开票)")
    private String invoiceStatus;

    /**
     *  客户联系人
     *  用于发送电子发票信息
     */
    @ApiModelProperty(value = "客户联系人")
    private Long khlxr;

    /**
     *  联系单上传状态
     *  FK = 开票 + 付款
     *  FP = 只开发票
     */
    @ApiModelProperty(value = "联系单上传状态")
    private String uptp;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态")
    private Integer cursp;

    /**
     * 要求支付的日期
     */
    @ApiModelProperty(value = "要求支付的日期")
    private String zfrq;

    /**
     * app审批的单号
     */
    @ApiModelProperty(value = "app审批的单号")
    private Long appdh;

    /**
     * 是否已完成收付款确认
     */
    private boolean isConfirm;

    /**
     * 结算日期
     */
    private String confirmDate;

    /**
     * 实收实付操作人
     */
    private Integer confirmUserId;

    @ApiModelProperty(value = "md5")
    private String md5;

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public FinancialSettlementDTO() {
    }

    public boolean isConfirm() {
        return isConfirm;
    }

    public void setConfirm(boolean confirm) {
        isConfirm = confirm;
    }

    public String getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(String confirmDate) {
        this.confirmDate = confirmDate;
    }

    public Integer getConfirmUserId() {
        return confirmUserId;
    }

    public void setConfirmUserId(Integer confirmUserId) {
        this.confirmUserId = confirmUserId;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public String getSettlementCode() {
        return settlementCode;
    }

    public void setSettlementCode(String settlementCode) {
        this.settlementCode = settlementCode;
    }

    public Integer getRegisterCompanyId() {
        return registerCompanyId;
    }

    public void setRegisterCompanyId(Integer registerCompanyId) {
        this.registerCompanyId = registerCompanyId;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public Integer getSettlementModeId() {
        return settlementModeId;
    }

    public void setSettlementModeId(Integer settlementModeId) {
        this.settlementModeId = settlementModeId;
    }

    public String getSettlementPurposeName() {
        return settlementPurposeName;
    }

    public void setSettlementPurposeName(String settlementPurposeName) {
        this.settlementPurposeName = settlementPurposeName;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getExchangeLossAmount() {
        return exchangeLossAmount;
    }

    public void setExchangeLossAmount(BigDecimal exchangeLossAmount) {
        this.exchangeLossAmount = exchangeLossAmount;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getDepartCode() {
        return departCode;
    }

    public void setDepartCode(Integer departCode) {
        this.departCode = departCode;
    }

    public Integer getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpzt() {
        return upzt;
    }

    public void setUpzt(String upzt) {
        this.upzt = upzt;
    }

    public Long getKhlxr() {
        return khlxr;
    }

    public void setKhlxr(Long khlxr) {
        this.khlxr = khlxr;
    }

    public String getUptp() {
        return uptp;
    }

    public void setUptp(String uptp) {
        this.uptp = uptp;
    }

    public Integer getCursp() {
        return cursp;
    }

    public void setCursp(Integer cursp) {
        this.cursp = cursp;
    }

    public String getZfrq() {
        return zfrq;
    }

    public void setZfrq(String zfrq) {
        this.zfrq = zfrq;
    }

    public Long getAppdh() {
        return appdh;
    }

    public void setAppdh(Long appdh) {
        this.appdh = appdh;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public String getCustomerTaxCode() {
        return customerTaxCode;
    }

    public void setCustomerTaxCode(String customerTaxCode) {
        this.customerTaxCode = customerTaxCode;
    }

    public String getCustomerAddress() {
        return customerAddress;
    }

    public void setCustomerAddress(String customerAddress) {
        this.customerAddress = customerAddress;
    }

    public String getCustomerPhone() {
        return customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getCustomerBankName() {
        return customerBankName;
    }

    public void setCustomerBankName(String customerBankName) {
        this.customerBankName = customerBankName;
    }

    public String getCustomerBankAccount() {
        return customerBankAccount;
    }

    public void setCustomerBankAccount(String customerBankAccount) {
        this.customerBankAccount = customerBankAccount;
    }

    public String getInvoiceReceiverName() {
        return invoiceReceiverName;
    }

    public void setInvoiceReceiverName(String invoiceReceiverName) {
        this.invoiceReceiverName = invoiceReceiverName;
    }

    public String getInvoiceReviewerName() {
        return invoiceReviewerName;
    }

    public void setInvoiceReviewerName(String invoiceReviewerName) {
        this.invoiceReviewerName = invoiceReviewerName;
    }

    public String getCenterSettlementCode() {
        return centerSettlementCode;
    }

    public void setCenterSettlementCode(String centerSettlementCode) {
        this.centerSettlementCode = centerSettlementCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        FinancialSettlementDTO that = (FinancialSettlementDTO) o;

        return new EqualsBuilder()
                .append(isConfirm, that.isConfirm)
                .append(settlementId, that.settlementId)
                .append(settlementCode, that.settlementCode)
                .append(centerSettlementCode, that.centerSettlementCode)
                .append(registerCompanyId, that.registerCompanyId)
                .append(customerCode, that.customerCode)
                .append(settlementType, that.settlementType)
                .append(settlementModeId, that.settlementModeId)
                .append(settlementPurposeName, that.settlementPurposeName)
                .append(currency, that.currency)
                .append(exchangeRate, that.exchangeRate)
                .append(amount, that.amount)
                .append(exchangeLossAmount, that.exchangeLossAmount)
                .append(invoiceTitle, that.invoiceTitle)
                .append(invoiceType, that.invoiceType)
                .append(customerTaxCode, that.customerTaxCode)
                .append(customerAddress, that.customerAddress)
                .append(customerPhone, that.customerPhone)
                .append(customerBankName, that.customerBankName)
                .append(customerBankAccount, that.customerBankAccount)
                .append(invoiceReceiverName, that.invoiceReceiverName)
                .append(invoiceReviewerName, that.invoiceReviewerName)
                .append(note, that.note)
                .append(departCode, that.departCode)
                .append(createdBy, that.createdBy)
                .append(createdTime, that.createdTime)
                .append(upzt, that.upzt)
                .append(invoiceStatus, that.invoiceStatus)
                .append(khlxr, that.khlxr)
                .append(uptp, that.uptp)
                .append(cursp, that.cursp)
                .append(zfrq, that.zfrq)
                .append(appdh, that.appdh)
                .append(confirmDate, that.confirmDate)
                .append(confirmUserId, that.confirmUserId)
                .append(md5, that.md5).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(settlementId)
                .append(settlementCode)
                .append(centerSettlementCode)
                .append(registerCompanyId).append(customerCode).append(settlementType).append(settlementModeId).append(settlementPurposeName).append(currency).append(exchangeRate).append(amount).append(exchangeLossAmount).append(invoiceTitle).append(invoiceType).append(customerTaxCode).append(customerAddress).append(customerPhone).append(customerBankName).append(customerBankAccount).append(invoiceReceiverName).append(invoiceReviewerName).append(note).append(departCode).append(createdBy).append(createdTime).append(upzt).append(invoiceStatus).append(khlxr).append(uptp).append(cursp).append(zfrq).append(appdh).append(isConfirm).append(confirmDate).append(confirmUserId).append(md5).toHashCode();
    }
}
