package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 联系单明细
 * @author paranoia
 */
@ApiModel(value = "联系单明细")
public class FinancialSettlementDetailDTO implements Serializable {

    /**
     * 结算id
     */
    @ApiModelProperty(value = "结算id")
    private String settlementDetailId;

    /**
     * 结算单号
     */
    @ApiModelProperty(value = "结算单号")
    private Long settlementId;

    /**
     * 账单明细id  财务结算中心
     */
    @ApiModelProperty(value = "账单明细id")
    private String chargeDetailId;

    /**
     *  账单id
     *  必填
     */
    @ApiModelProperty(value = "账单id")
    private Long billId;

    /**
     *  账单号
     *  必填
     */
    @ApiModelProperty(value = "账单号")
    private String billNo;

    /**
     *  费种id
     *  必填
     */
    @ApiModelProperty(value = "费种id")
    private Integer feeId;

    /**
     *  外币币种
     *  必填
     */
    @ApiModelProperty(value = "外币币种")
    private String currency;

    /**
     *  账单明细金额
     *  必填
     */
    @ApiModelProperty(value = "账单明细金额")
    private BigDecimal chargeAmount;

    /**
     *  结算金额
     *  必填
     */
    @ApiModelProperty(value = "结算金额")
    private BigDecimal settlementAmount;

    @ApiModelProperty(value = "业务id")
    private String orderId;

    /**
     *  业务单号
     *  必填，联系单明细对应账单明细对应账单对应的业务主单号
     */
    @ApiModelProperty(value = "业务单号")
    private String orderNo;

    @ApiModelProperty(value = "md5")
    private String md5;

    public FinancialSettlementDetailDTO() {
    }

    public String getSettlementDetailId() {
        return settlementDetailId;
    }

    public void setSettlementDetailId(String settlementDetailId) {
        this.settlementDetailId = settlementDetailId;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public String getChargeDetailId() {
        return chargeDetailId;
    }

    public void setChargeDetailId(String chargeDetailId) {
        this.chargeDetailId = chargeDetailId;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Integer getFeeId() {
        return feeId;
    }

    public void setFeeId(Integer feeId) {
        this.feeId = feeId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getChargeAmount() {
        return chargeAmount;
    }

    public void setChargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    public void setSettlementAmount(BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        FinancialSettlementDetailDTO that = (FinancialSettlementDetailDTO) o;

        return new EqualsBuilder()
                .append(settlementDetailId, that.settlementDetailId)
                .append(settlementId, that.settlementId)
                .append(chargeDetailId, that.chargeDetailId)
                .append(billId, that.billId)
                .append(billNo, that.billNo)
                .append(feeId, that.feeId)
                .append(currency, that.currency)
                .append(chargeAmount, that.chargeAmount)
                .append(settlementAmount, that.settlementAmount)
                .append(orderId, that.orderId)
                .append(orderNo, that.orderNo)
                .append(md5, that.md5)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(settlementDetailId)
                .append(settlementId)
                .append(chargeDetailId)
                .append(billId)
                .append(billNo)
                .append(feeId)
                .append(currency)
                .append(chargeAmount)
                .append(settlementAmount)
                .append(orderId)
                .append(orderNo)
                .append(md5)
                .toHashCode();
    }
}
