package com.wisdom.financial.domain.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.Date;
@ApiModel(value = "陆运业务信息")
public class LYBusinessInfoDTO implements Serializable {
    @ApiModelProperty(value = "ywid")
    private Long ywid;

    @ApiModelProperty(value = "运单号")
    private String shipmentCode;

    @ApiModelProperty(value = "实际开始运输时间")
    private Date factTransportStartTime;

    @ApiModelProperty(value = "实际运输完结时间")
    private Date factTransportEndTime;

    @ApiModelProperty(value = "运单状态")
    private Integer shipmentStatus;

    @ApiModelProperty(value = "司机代码")
    private String driverCode;

    @ApiModelProperty(value = "司机名称")
    private String driverName;

    @ApiModelProperty(value = "司机车牌号")
    private String driveLicense;

    @ApiModelProperty(value = "出发站点编码")
    private String fromStation;

    @ApiModelProperty(value = "目的站点编码")
    private String toStation;

    @ApiModelProperty(value = "客户单号")
    private String customerOrderNo;

    @ApiModelProperty(value = "船名")
    private String vessel;

    @ApiModelProperty(value = "航次")
    private String voyage;

    @ApiModelProperty(value = "箱型代码")
    private String containerCode;

    @ApiModelProperty(value = "箱型名称")
    private String containerType;

    @ApiModelProperty(value = "箱属")
    private String containerBelong;

    @ApiModelProperty(value = "箱型信息")
    private String containerInfo;

    @ApiModelProperty(value = "箱数量")
    private Integer containerQuantity;

    @ApiModelProperty(value = "空重")
    private Integer heavySign;

    @ApiModelProperty(value = "业务系统业务流水号")
    private String orderNo;

    @ApiModelProperty(value = "提单号")
    private String blNo;


    public LYBusinessInfoDTO() {
    }

    public Long getYwid() {
        return ywid;
    }

    public void setYwid(Long ywid) {
        this.ywid = ywid;
    }

    public String getShipmentCode() {
        return shipmentCode;
    }

    public void setShipmentCode(String shipmentCode) {
        this.shipmentCode = shipmentCode;
    }

    public Date getFactTransportStartTime() {
        return factTransportStartTime;
    }

    public void setFactTransportStartTime(Date factTransportStartTime) {
        this.factTransportStartTime = factTransportStartTime;
    }

    public Date getFactTransportEndTime() {
        return factTransportEndTime;
    }

    public void setFactTransportEndTime(Date factTransportEndTime) {
        this.factTransportEndTime = factTransportEndTime;
    }

    public Integer getShipmentStatus() {
        return shipmentStatus;
    }

    public void setShipmentStatus(Integer shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public String getDriverCode() {
        return driverCode;
    }

    public void setDriverCode(String driverCode) {
        this.driverCode = driverCode;
    }

    public String getDriverName() {
        return driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDriveLicense() {
        return driveLicense;
    }

    public void setDriveLicense(String driveLicense) {
        this.driveLicense = driveLicense;
    }

    public String getFromStation() {
        return fromStation;
    }

    public void setFromStation(String fromStation) {
        this.fromStation = fromStation;
    }

    public String getToStation() {
        return toStation;
    }

    public void setToStation(String toStation) {
        this.toStation = toStation;
    }

    public String getCustomerOrderNo() {
        return customerOrderNo;
    }

    public void setCustomerOrderNo(String customerOrderNo) {
        this.customerOrderNo = customerOrderNo;
    }

    public String getVessel() {
        return vessel;
    }

    public void setVessel(String vessel) {
        this.vessel = vessel;
    }

    public String getVoyage() {
        return voyage;
    }

    public void setVoyage(String voyage) {
        this.voyage = voyage;
    }

    public String getContainerCode() {
        return containerCode;
    }

    public void setContainerCode(String containerCode) {
        this.containerCode = containerCode;
    }

    public String getContainerType() {
        return containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public String getContainerBelong() {
        return containerBelong;
    }

    public void setContainerBelong(String containerBelong) {
        this.containerBelong = containerBelong;
    }

    public String getContainerInfo() {
        return containerInfo;
    }

    public void setContainerInfo(String containerInfo) {
        this.containerInfo = containerInfo;
    }

    public Integer getContainerQuantity() {
        return containerQuantity;
    }

    public void setContainerQuantity(Integer containerQuantity) {
        this.containerQuantity = containerQuantity;
    }

    public Integer getHeavySign() {
        return heavySign;
    }

    public void setHeavySign(Integer heavySign) {
        this.heavySign = heavySign;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBlNo() {
        return blNo;
    }

    public void setBlNo(String blNo) {
        this.blNo = blNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof LYBusinessInfoDTO)) {
            return false;
        }

        LYBusinessInfoDTO that = (LYBusinessInfoDTO) o;

        return new EqualsBuilder()
                .append(getYwid(), that.getYwid())
                .append(getShipmentCode(), that.getShipmentCode())
                .append(getFactTransportStartTime(), that.getFactTransportStartTime())
                .append(getFactTransportEndTime(), that.getFactTransportEndTime())
                .append(getShipmentStatus(), that.getShipmentStatus())
                .append(getDriverCode(), that.getDriverCode())
                .append(getDriverName(), that.getDriverName())
                .append(getDriveLicense(), that.getDriveLicense())
                .append(getFromStation(), that.getFromStation())
                .append(getToStation(), that.getToStation())
                .append(getCustomerOrderNo(), that.getCustomerOrderNo())
                .append(getVessel(), that.getVessel())
                .append(getVoyage(), that.getVoyage())
                .append(getContainerCode(), that.getContainerCode())
                .append(getContainerType(), that.getContainerType())
                .append(getContainerBelong(), that.getContainerBelong())
                .append(getContainerInfo(), that.getContainerInfo())
                .append(getContainerQuantity(), that.getContainerQuantity())
                .append(getHeavySign(), that.getHeavySign())
                .append(getOrderNo(), that.getOrderNo())
                .append(getBlNo(), that.getBlNo())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(getYwid())
                .append(getShipmentCode())
                .append(getFactTransportStartTime())
                .append(getFactTransportEndTime())
                .append(getShipmentStatus())
                .append(getDriverCode())
                .append(getDriverName())
                .append(getDriveLicense())
                .append(getFromStation())
                .append(getToStation())
                .append(getCustomerOrderNo())
                .append(getVessel())
                .append(getVoyage())
                .append(getContainerCode())
                .append(getContainerType())
                .append(getContainerBelong())
                .append(getContainerInfo())
                .append(getContainerQuantity())
                .append(getHeavySign())
                .append(getOrderNo())
                .append(getBlNo())
                .toHashCode();
    }
}
