package com.wisdom.financial.domain.request;

import com.wisdom.financial.domain.vm.FinancialChargeVM;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 月末结转 抓取账单数据请求体
 *
 * @author paranoia
 */
@ApiModel(value = "月末结转上传账单数据结构")
public class PushFinancialOrderRequest implements Serializable {

    /**
     * 业务系统注册号
     */
    @NotNull(message = "osbid不能为空")
    @ApiModelProperty(value = "业务系统注册号")
    private Integer osbid;

    /**
     * 转账id集合
     */
    @ApiModelProperty(value = "转账id集合")
    private List<Long> transferIds;

    @ApiModelProperty(value = "月末结转上传账单数据结构集合")
    private List<FinancialChargeVM> financialChargeVMList;

    public PushFinancialOrderRequest() {
    }

    public List<Long> getTransferIds() {
        return transferIds;
    }

    public void setTransferIds(List<Long> transferIds) {
        this.transferIds = transferIds;
    }

    public Integer getOsbid() {
        return osbid;
    }

    public void setOsbid(Integer osbid) {
        this.osbid = osbid;
    }

    public List<FinancialChargeVM> getFinancialChargeVMList() {
        return financialChargeVMList;
    }

    public void setFinancialChargeVMList(List<FinancialChargeVM> financialChargeVMList) {
        this.financialChargeVMList = financialChargeVMList;
    }
}
