package com.wisdom.financial.domain.request;

import com.wisdom.financial.domain.vm.FinancialSettlementVM;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author paranoia
 */
@ApiModel(value = "上传联系单请求对象")
public class PushFinancialSettlementRequest implements Serializable {
    /**
     * 业务系统注册号
     */
    @ApiModelProperty(value = "业务系统注册号")
    private Integer registerCompanyId;

    /**
     * 上传结算单号集合
     */
    @ApiModelProperty(value = "上传结算单号集合")
    private List<String> settlementIds;

    /**
     *  上传联系单数据结构
     *  rpc 调用方式非必填
     */
    @ApiModelProperty(value = "上传联系单数据结构 rpc 调用方式非必填")
    private List<FinancialSettlementVM> financialSettlementVMList;

    public PushFinancialSettlementRequest() {
    }

    public Integer getRegisterCompanyId() {
        return registerCompanyId;
    }

    public void setRegisterCompanyId(Integer registerCompanyId) {
        this.registerCompanyId = registerCompanyId;
    }

    public List<String> getSettlementIds() {
        return settlementIds;
    }

    public void setSettlementIds(List<String> settlementIds) {
        this.settlementIds = settlementIds;
    }

    public List<FinancialSettlementVM> getFinancialSettlementVMList() {
        return financialSettlementVMList;
    }

    public void setFinancialSettlementVMList(List<FinancialSettlementVM> financialSettlementVMList) {
        this.financialSettlementVMList = financialSettlementVMList;
    }
}
