package com.wisdom.financial.domain.vm;

import com.wisdom.financial.domain.dto.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 月末结转上传账单数据结构
 * @author paranoia 2020/6/17
 */
@ApiModel(value = "月末结转上传账单数据结构")
public class FinancialChargeVM implements Serializable {

    /**
     *  业务系统转账Id
     */
    @ApiModelProperty(value = "业务系统转账Id")
    private Long transferId;

    /**
     *  转账人JobId
     */
    @ApiModelProperty(value = "转账人JobId")
    private Integer transferJobId;

    /**
     * 转账部门代码
     */
    @ApiModelProperty(value = "转账部门代码")
    private Integer transferDepartCode;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    private String businessType;

    /**
     *  待上传账单数据
     */
    @ApiModelProperty(value = "账单")
    private List<FinancialOrderDTO> financialOrderDTOList;

    /**
     *  待上传账单明细数据
     */
    @ApiModelProperty(value = "账单明细")
    private List<FinancialOrderDetailDTO> financialOrderDetailDTOList;

    /**
     *  业务汇总 待上传账单对应的业务汇总数据
     */
    @ApiModelProperty(value = "业务汇总")
    private List<FinancialBusinessInfoDTO> financialBusinessInfoDTOList;

    /**
     *  转账id对应的业务系统账单号 用来回写业务系统转账id
     */
    @ApiModelProperty(value = "业务系统账单号集合")
    private List<String> chargeIds;

    /**
     * 转账id对应的业务系统账单明细数据集 用于在月末结转账单上传时校验账单的一致性。
     */
    @ApiModelProperty(value = "月末结转账单数据上传时校验类")
    private List<FinancialOrderDetailCheckDTO> financialOrderDetailCheckDTOList;

    /**
     *  一次转账id 合计本位币应收
     */
    @ApiModelProperty(value = "一次转账id 合计本位币应收")
    private BigDecimal standardAmountReceivable;

    /**
     *  一次转账id 合计本位币应付
     */
    @ApiModelProperty(value = "一次转账id 合计本位币应付")
    private BigDecimal standardAmountPayable;

    /**
     *  陆运业务信息
     */
    @ApiModelProperty(value = "陆运业务信息")
    private List<LYBusinessInfoDTO> lyBusinessInfoDTOList;

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getTransferId() {
        return transferId;
    }

    public void setTransferId(Long transferId) {
        this.transferId = transferId;
    }

    public Integer getTransferJobId() {
        return transferJobId;
    }

    public void setTransferJobId(Integer transferJobId) {
        this.transferJobId = transferJobId;
    }

    public Integer getTransferDepartCode() {
        return transferDepartCode;
    }

    public void setTransferDepartCode(Integer transferDepartCode) {
        this.transferDepartCode = transferDepartCode;
    }

    public FinancialChargeVM() {
    }

    public List<FinancialOrderDTO> getFinancialOrderDTOList() {
        return financialOrderDTOList;
    }

    public void setFinancialOrderDTOList(List<FinancialOrderDTO> financialOrderDTOList) {
        this.financialOrderDTOList = financialOrderDTOList;
    }

    public List<FinancialOrderDetailDTO> getFinancialOrderDetailDTOList() {
        return financialOrderDetailDTOList;
    }

    public void setFinancialOrderDetailDTOList(List<FinancialOrderDetailDTO> financialOrderDetailDTOList) {
        this.financialOrderDetailDTOList = financialOrderDetailDTOList;
    }

    public List<FinancialBusinessInfoDTO> getFinancialBusinessInfoDTOList() {
        return financialBusinessInfoDTOList;
    }

    public void setFinancialBusinessInfoDTOList(List<FinancialBusinessInfoDTO> financialBusinessInfoDTOList) {
        this.financialBusinessInfoDTOList = financialBusinessInfoDTOList;
    }

    public List<LYBusinessInfoDTO> getLyBusinessInfoDTOList() {
        return lyBusinessInfoDTOList;
    }

    public void setLyBusinessInfoDTOList(List<LYBusinessInfoDTO> lyBusinessInfoDTOList) {
        this.lyBusinessInfoDTOList = lyBusinessInfoDTOList;
    }

    public List<String> getChargeIds() {
        return chargeIds;
    }

    public void setChargeIds(List<String> chargeIds) {
        this.chargeIds = chargeIds;
    }

    public BigDecimal getStandardAmountReceivable() {
        return standardAmountReceivable;
    }

    public void setStandardAmountReceivable(BigDecimal standardAmountReceivable) {
        this.standardAmountReceivable = standardAmountReceivable;
    }

    public BigDecimal getStandardAmountPayable() {
        return standardAmountPayable;
    }

    public void setStandardAmountPayable(BigDecimal standardAmountPayable) {
        this.standardAmountPayable = standardAmountPayable;
    }

    public List<FinancialOrderDetailCheckDTO> getFinancialOrderDetailCheckDTOList() {
        return financialOrderDetailCheckDTOList;
    }

    public void setFinancialOrderDetailCheckDTOList(List<FinancialOrderDetailCheckDTO> financialOrderDetailCheckDTOList) {
        this.financialOrderDetailCheckDTOList = financialOrderDetailCheckDTOList;
    }
}
