package com.wisdom.financial.domain.vm;

import com.wisdom.financial.domain.dto.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 上传联系单数据结构
 * @author paranoia
 */
@ApiModel(value = "上传联系单数据结构")
public class FinancialSettlementVM implements Serializable {
    /**
     * 结算单汇总数据
     */
    @ApiModelProperty(value = "结算单汇总")
    private FinancialSettlementDTO financialSettlementDTO;

    /**
     * 结算单明细数据
     */
    @ApiModelProperty(value = "结算单明细数据集合")
    private List<FinancialSettlementDetailDTO> financialSettlementDetailDTOList;

    /**
     * 账单汇总数据
     */
    @ApiModelProperty(value = "账单汇总数据集合")
    private List<FinancialOrderDTO> financialOrderDTOList;

    /**
     * 账单明细数据
     */
    @ApiModelProperty(value = "账单明细数据集合")
    private List<FinancialOrderDetailDTO> financialOrderDetailDTOList;

    /**
     * 业务汇总数据
     */
    @ApiModelProperty(value = "业务汇总数据集合")
    private List<FinancialBusinessInfoDTO> financialBusinessInfoDTOList;

    /**
     * 发票抬头信息，销货方和购货方
     */
    @ApiModelProperty(value = "发票抬头信息，销货方和购货方")
    private FinancialInvoiceBaseInfo financialInvoiceBaseInfo;

    /**
     *  电子发票通知人信息
     */
    @ApiModelProperty(value = "电子发票通知人信息")
    private FinancialInvoiceNotifierDTO financialInvoiceNotifier;

    /**
     * 陆运业务信息
     */
    @ApiModelProperty(value = "陆运业务信息")
    private List<LYBusinessInfoDTO> lyBusinessInfoDTOList;

    /**
     * 冷链业务信息
     */
    @ApiModelProperty(value = "冷链业务信息")
    private List<LLBusinessInfoDTO> llBusinessInfoDTOList;

    /**
     * 发票信息数据
     * 不需要上传，测试使用
     */
    @ApiModelProperty(value = "发票信息数据 不需要上传，测试使用")
    private List<FinancialInvoiceDTO> financialInvoiceDTOList;

    /**
     * 是否申请开具发票
     */
    @ApiModelProperty(value = "是否申请开具发票")
    private boolean isOpenInvoice;

    public FinancialSettlementVM() {
    }

    public FinancialSettlementDTO getFinancialSettlementDTO() {
        return financialSettlementDTO;
    }

    public void setFinancialSettlementDTO(FinancialSettlementDTO financialSettlementDTO) {
        this.financialSettlementDTO = financialSettlementDTO;
    }

    public List<FinancialSettlementDetailDTO> getFinancialSettlementDetailDTOList() {
        return financialSettlementDetailDTOList;
    }

    public void setFinancialSettlementDetailDTOList(List<FinancialSettlementDetailDTO> financialSettlementDetailDTOList) {
        this.financialSettlementDetailDTOList = financialSettlementDetailDTOList;
    }

    public List<FinancialOrderDTO> getFinancialOrderDTOList() {
        return financialOrderDTOList;
    }

    public void setFinancialOrderDTOList(List<FinancialOrderDTO> financialOrderDTOList) {
        this.financialOrderDTOList = financialOrderDTOList;
    }

    public List<FinancialOrderDetailDTO> getFinancialOrderDetailDTOList() {
        return financialOrderDetailDTOList;
    }

    public void setFinancialOrderDetailDTOList(List<FinancialOrderDetailDTO> financialOrderDetailDTOList) {
        this.financialOrderDetailDTOList = financialOrderDetailDTOList;
    }

    public List<FinancialBusinessInfoDTO> getFinancialBusinessInfoDTOList() {
        return financialBusinessInfoDTOList;
    }

    public void setFinancialBusinessInfoDTOList(List<FinancialBusinessInfoDTO> financialBusinessInfoDTOList) {
        this.financialBusinessInfoDTOList = financialBusinessInfoDTOList;
    }

    public List<LYBusinessInfoDTO> getLyBusinessInfoDTOList() {
        return lyBusinessInfoDTOList;
    }

    public void setLyBusinessInfoDTOList(List<LYBusinessInfoDTO> lyBusinessInfoDTOList) {
        this.lyBusinessInfoDTOList = lyBusinessInfoDTOList;
    }

    public List<FinancialInvoiceDTO> getFinancialInvoiceDTOList() {
        return financialInvoiceDTOList;
    }

    public void setFinancialInvoiceDTOList(List<FinancialInvoiceDTO> financialInvoiceDTOList) {
        this.financialInvoiceDTOList = financialInvoiceDTOList;
    }

    public boolean isOpenInvoice() {
        return isOpenInvoice;
    }

    public void setOpenInvoice(boolean openInvoice) {
        isOpenInvoice = openInvoice;
    }

    public FinancialInvoiceBaseInfo getFinancialInvoiceBaseInfo() {
        return financialInvoiceBaseInfo;
    }

    public void setFinancialInvoiceBaseInfo(FinancialInvoiceBaseInfo financialInvoiceBaseInfo) {
        this.financialInvoiceBaseInfo = financialInvoiceBaseInfo;
    }

    public FinancialInvoiceNotifierDTO getFinancialInvoiceNotifier() {
        return financialInvoiceNotifier;
    }

    public void setFinancialInvoiceNotifier(FinancialInvoiceNotifierDTO financialInvoiceNotifier) {
        this.financialInvoiceNotifier = financialInvoiceNotifier;
    }

    public List<LLBusinessInfoDTO> getLlBusinessInfoDTOList() {
        return llBusinessInfoDTOList;
    }

    public void setLlBusinessInfoDTOList(List<LLBusinessInfoDTO> llBusinessInfoDTOList) {
        this.llBusinessInfoDTOList = llBusinessInfoDTOList;
    }
}
