package com.wisdom.financial.service.base;

import com.wisdom.boot.common.model.result.Result;
import com.wisdom.financial.domain.dto.FinancialInvoiceDTO;
import com.wisdom.financial.domain.vm.FinancialInvoiceVm;

import java.util.List;

/**
 * 发票Service
 * @author paranoia
 */
public interface InvoiceService {

    /**
     * 回写发票信息至业务系统
     * @param financialInvoiceVm 发票信息结构
     * @return Result
     */
    Result<?> syncInvoiceData(FinancialInvoiceVm financialInvoiceVm);

    /**
     * 作废或红冲发票
     * @param financialInvoiceDTO 发票信息
     * @return Result
     */
    Result<?> invalidInvoice(FinancialInvoiceDTO financialInvoiceDTO);

    /**
     * 核销发票
     * @param invoiceIds 结算中心发票id
     * @param invoiceRemark 核销发票备注信息
     * @return Result
     */
    Result<?> writeOffInvoice(List<Long> invoiceIds, String invoiceRemark);
}
