package com.wisdom.financial.service.base;

import com.wisdom.boot.common.model.result.Result;
import com.wisdom.financial.domain.request.PushFinancialOrderRequest;
import com.wisdom.financial.domain.vm.FinancialChargeVM;

import java.util.List;

/**
 * @author paranoia
 */
public interface OrderService {
    /**
     * 生成月末结转账单数据
     * @param request 请求参数
     * @return FinancialChargeVM
     */
    List<FinancialChargeVM> generateFinancialOrderData(PushFinancialOrderRequest request);

    /**
     * 上传月末结转账单数据后更新上传标记
     * @param financialChargeVMList 请求参数
     * @return Result
     */
    Result<?> updateOrderUploadFlag(List<FinancialChargeVM> financialChargeVMList);
}
