package com.wisdom.financial.service.base;

import com.wisdom.boot.common.model.result.Result;
import com.wisdom.financial.domain.request.PushFinancialSettlementRequest;
import com.wisdom.financial.domain.request.RevertFinancialSettlementRequest;
import com.wisdom.financial.domain.vm.FinancialSettlementVM;

import java.util.List;

/**
 * @author paranoia
 */
public interface SettlementService {
    /**
     * 更新联系单上传标记
     * 记录联系单已上传和账单明细已上传。
     * 联系单已上传结算中心后业务系统联系单数据不可再调整。
     * @param financialSettlementVMList 联系单数据集
     * @return Result
     */
    Result<?> updateSettlementUploadFlag(List<FinancialSettlementVM> financialSettlementVMList);

    /**
     * 撤销联系单上传
     * 结算中心撤销联系单上传后，调用业务系统实现接口同步更新业务系统。
     * @param request PushFinancialSettlementRequest
     * @return Result
     */
    Result<?> revertSettlementUpload(RevertFinancialSettlementRequest request);

    /**
     * 根据联系单号上传联系单数据，同时包含联系单相关账单数据，业务汇总数据。
     * @param request 备注
     * @return Result
     */
    Result<List<FinancialSettlementVM>> generateFinancialSettlementData(PushFinancialSettlementRequest request);
}
