/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.license;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SystemInfoService {
    public static void main(String[] args) {
        SystemInfoService.printIPAndMac();
    }

    public static List<String> getAllMacs() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                macList.add(sb.toString());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return macList;
    }

    public static List<String> getAllIP() {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ipList.add(ips.nextElement().getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipList;
    }

    public static void printIPAndMac() {
        List<String> allIP = SystemInfoService.getAllIP();
        allIP.forEach(x -> System.out.println((String)x));
        List<String> allMacs = SystemInfoService.getAllMacs();
        allMacs.forEach(y -> System.out.println((String)y));
    }
}

