/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.Behavior;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.Label;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.element.store.Warehouse;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.utils.Categories;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainStorageAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(MainStorageAlgorithm.class);

    private MainStorageAlgorithm() {
    }

    public static double getRecommendedValue(Label<?, ?> ... labels) {
        double[] deltas = new double[labels.length];
        double[] wdeltas = new double[labels.length];
        double[] xs = new double[labels.length];
        IntStream.range(0, deltas.length).forEach(i -> {
            deltas[i] = labels[i].policy().delta();
            xs[i] = labels[i].getX();
            wdeltas[i] = StorageConst.calculateWeightedDelta(deltas[i], labels[i].policy().getLevel(), xs[i]);
        });
        double[] cov = StorageConst.covDiagMatrix(deltas);
        double[] wcov = StorageConst.covDiagMatrix(wdeltas);
        double det = StorageConst.diagDet(wcov);
        double[] inv = StorageConst.diagMrinv(cov);
        double result = StorageConst.indepNormDistribution(inv, det, xs);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            IntStream.range(0, deltas.length).forEach(i -> {
                sb.append(labels[i].tag());
                sb.append(": ");
                sb.append(xs[i]);
                if ((i + 1) % 5 == 0) {
                    sb.append("\n");
                } else {
                    sb.append("\t");
                }
            });
            sb.append("\u63a8\u8350\u503c\uff1a");
            sb.append(result);
            LOG.debug(sb.toString());
        }
        return result;
    }

    public static double[] getRecommendedCov(Label<?, ?> ... labels) {
        double[] deltas = new double[labels.length];
        IntStream.range(0, deltas.length).forEach(i -> {
            deltas[i] = 1.0;
        });
        return StorageConst.covDiagMatrix(deltas);
    }

    public static double getRecommendedValue(double det, double[] inv, Label<?, ?> ... labels) {
        double[] xs = new double[labels.length];
        IntStream.range(0, xs.length).forEach(i -> {
            xs[i] = labels[i].getX();
        });
        return StorageConst.indepNormDistribution(inv, det, xs);
    }

    public static List<Label<?, ?>> populateLabels(Cubicle cube, CommonParams expectedParam) {
        ArrayList ret = new ArrayList();
        cube.getLabels().stream().forEach(cubeLabel -> {
            CubiclePolicy cubePolicy;
            if (cubeLabel.policy().getMode() == AlgorithomMode.IGNORE) {
                return;
            }
            if (cubeLabel.policy() instanceof CubiclePolicy && (cubePolicy = (CubiclePolicy)cubeLabel.policy()).supportedCarType() != expectedParam.getCarType() && cubePolicy.supportedCarType() != StockType.BOTH) {
                return;
            }
            cubeLabel.setValue(expectedParam);
            ret.add((Label<?, ?>)cubeLabel);
        });
        ret.addAll(MainStorageAlgorithm.populateLabels(cube.getMyAlley(), expectedParam));
        return ret;
    }

    public static List<Label<?, ?>> populateLabels(Alley alley, CommonParams expectedParam) {
        ArrayList ret = new ArrayList();
        alley.getLabels().stream().forEach(alleyLabel -> {
            AlleyPolicy alleyPolicy;
            if (alleyLabel.policy().getMode() == AlgorithomMode.IGNORE) {
                return;
            }
            if (alleyLabel.policy() instanceof AlleyPolicy && (alleyPolicy = (AlleyPolicy)alleyLabel.policy()).supportedCarType() != expectedParam.getCarType() && alleyPolicy.supportedCarType() != StockType.BOTH) {
                return;
            }
            alleyLabel.setValue(expectedParam);
            ret.add((Label<?, ?>)alleyLabel);
        });
        return ret;
    }

    private static synchronized Cubicle getARecommendedCube(CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveIn) {
            throw new StatusException("\u5165\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u51fa\u5e93\u53c2\u6570\uff01");
        }
        expectedParam.initBeforeEverySearch();
        ArrayList cubes = new ArrayList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5f00\u59cb\u8ba1\u7b97\u4e00\u4e2a\u5165\u5e93\u5e93\u4f4d\u3002");
        }
        Warehouse.INST.getAllDistricts().stream().filter(district -> district.getId().equals(expectedParam.getMyDistrict().getId())).forEach(district -> district.getAlleys().stream().filter(alley -> !alley.getDistrict().isStacker() || expectedParam.getStackers().size() == 0 || expectedParam.getStackers().contains(alley.getStacker())).forEach(alley -> alley.getMyCubicle().stream().filter(cubicle -> cubicle.getMyBracket() == null && cubicle.getStatus() == StockStatus.empty).forEach(cubicle -> {
            List<Label<?, ?>> labels = MainStorageAlgorithm.populateLabels(cubicle, expectedParam);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u8ba1\u7b97  " + cubicle + " \u7684\u5165\u5e93\u53c2\u6570\uff1a");
            }
            cubicle.setRecommendedValue(MainStorageAlgorithm.getRecommendedValue(labels.toArray(new Label[0])));
            cubes.add(cubicle);
        })));
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5b8c\u6210\u8ba1\u7b97\u4e00\u4e2a\u5165\u5e93\u5e93\u4f4d\u3002");
        }
        if (cubes.size() == 0) {
            return null;
        }
        Object[] cubicles = cubes.toArray(new Cubicle[0]);
        Arrays.sort(cubicles);
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5f97\u5230\u5165\u5e93\u4f4d " + cubicles[cubicles.length - 1]);
        }
        return cubicles[cubicles.length - 1];
    }

    public static synchronized Alley getARecommendedAlley(CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveIn) {
            throw new StatusException("\u5165\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u51fa\u5e93\u53c2\u6570\uff01");
        }
        expectedParam.initBeforeEverySearch();
        ArrayList alleys = new ArrayList();
        Warehouse.INST.getAllDistricts().stream().filter(district -> district.getId().equals(expectedParam.getMyDistrict().getId())).forEach(district -> district.getAlleys().stream().filter(alley -> !alley.getDistrict().isStacker() || expectedParam.getStackers().contains(alley.getStacker())).forEach(alley -> {
            List<Label<?, ?>> labels = MainStorageAlgorithm.populateLabels(alley, expectedParam);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u8ba1\u7b97  " + alley + " \u7684\u5165\u5df7\u53c2\u6570\uff1a");
            }
            alley.setRecommendedValue(MainStorageAlgorithm.getRecommendedValue(labels.toArray(new Label[0])));
            alleys.add(alley);
        }));
        if (alleys.size() == 0) {
            return null;
        }
        Object[] as = alleys.toArray(new Alley[0]);
        Arrays.sort(as);
        return as[as.length - 1];
    }

    public static synchronized List<Cubicle> getMultipleRecommendedCube(CommonParams expectedParam, int num) {
        if (expectedParam.getNewBracket() == null) {
            throw new StatusException("\u8f93\u5165\u53c2\u6570\u4e2d\u8bf7\u52a0\u5165\u5f53\u524d\u8d27\u7269\uff01");
        }
        List<Bracket> newBrackets = Stream.generate(() -> {
            Bracket bracket = new Bracket();
            expectedParam.getNewBracket().copyTo(bracket);
            return bracket;
        }).limit(num).collect(Collectors.toList());
        return MainStorageAlgorithm.getMultipleRecommendedCube(expectedParam, newBrackets);
    }

    public static synchronized List<Cubicle> getMultipleRecommendedCube(CommonParams expectedParam, List<Bracket> newBrackets) {
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        newBrackets.stream().forEach(bracket -> {
            Stacker stacker;
            expectedParam.setNewBracket((Bracket)bracket);
            Cubicle cube = MainStorageAlgorithm.getARecommendedCube(expectedParam);
            if (cube == null || cube.getRecommendedValue() < StorageConst.minimumRecommendedValue) {
                LOG.error("\u8d27\u7269 " + bracket + " \u627e\u4e0d\u5230\u5408\u9002\u7684\u5165\u5e93\u4f4d\u7ed9!");
                return;
            }
            Bracket newBracket = new Bracket();
            expectedParam.getNewBracket().copyTo(newBracket);
            cube.setBracket(newBracket);
            cube.setStatus(StockStatus.locked_in);
            expectedParam.moveCar2Last(cube);
            expectedParam.moveFixedFloor2Last(cube.getFloor());
            if (expectedParam.getLeftCargoNumber() > 0) {
                expectedParam.setLeftCargoNumber(expectedParam.getLeftCargoNumber() - 1);
            }
            if (expectedParam.getMyDistrict().isShuttle() && expectedParam.getMissionNumber(cube.getFloor()) != -1) {
                int missionNumber = expectedParam.getMissionNumber(cube.getFloor());
                expectedParam.addMission(cube.getFloor(), ++missionNumber);
            }
            if ((stacker = cube.getMyAlley().getStacker()) != null) {
                stacker.setMissionNumber(stacker.getMissionNumber() + 1);
            }
            ret.add(cube);
        });
        return ret;
    }

    public static synchronized List<Cubicle> getMultipleRecommendedCube(List<CommonParams> expectedParams, List<Bracket> newBrackets) {
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        newBrackets.stream().forEach(bracket -> {
            Stacker stacker;
            Cubicle cube = null;
            CommonParams leftParam = null;
            for (int i = 0; i < expectedParams.size(); ++i) {
                Cubicle tmpCube = MainStorageAlgorithm.getARecommendedCube((CommonParams)expectedParams.get(i));
                if (tmpCube == null || tmpCube.getRecommendedValue() < StorageConst.minimumRecommendedValue || cube != null && !(tmpCube.getRecommendedValue() > cube.getRecommendedValue())) continue;
                cube = tmpCube;
                leftParam = (CommonParams)expectedParams.get(i);
            }
            if (cube == null) {
                LOG.error("\u8d27\u7269 " + bracket + " \u627e\u4e0d\u5230\u5408\u9002\u7684\u5165\u5e93\u4f4d\u7ed9!");
                return;
            }
            Bracket newBracket = new Bracket();
            leftParam.getNewBracket().copyTo(newBracket);
            cube.setBracket(newBracket);
            cube.setStatus(StockStatus.locked_in);
            leftParam.moveCar2Last(cube);
            leftParam.moveFixedFloor2Last(cube.getFloor());
            if (leftParam.getLeftCargoNumber() > 0) {
                leftParam.setLeftCargoNumber(leftParam.getLeftCargoNumber() - 1);
            }
            if (leftParam.getMyDistrict().isShuttle() && leftParam.getMissionNumber(cube.getFloor()) != -1) {
                int missionNumber = leftParam.getMissionNumber(cube.getFloor());
                leftParam.addMission(cube.getFloor(), ++missionNumber);
            }
            if ((stacker = cube.getMyAlley().getStacker()) != null) {
                stacker.setMissionNumber(stacker.getMissionNumber() + 1);
            }
            ret.add(cube);
        });
        return ret;
    }

    private static synchronized Cubicle getAMoveOutCube(CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        expectedParam.initBeforeEverySearch();
        ArrayList cubes = new ArrayList();
        expectedParam.getSameCubicles().stream().filter(cubicle -> cubicle.getStatus() != StockStatus.locked_out).forEach(cubicle -> {
            List<Label<?, ?>> labels = MainStorageAlgorithm.populateLabels(cubicle, expectedParam);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u8ba1\u7b97  " + cubicle + " \u7684\u51fa\u5e93\u53c2\u6570\uff1a");
            }
            cubicle.setRecommendedValue(MainStorageAlgorithm.getRecommendedValue(labels.toArray(new Label[0])));
            cubes.add(cubicle);
        });
        if (cubes.size() == 0) {
            return null;
        }
        Object[] cubicles = cubes.toArray(new Cubicle[0]);
        Arrays.sort(cubicles);
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5f97\u5230\u51fa\u5e93\u4f4d " + cubicles[cubicles.length - 1]);
        }
        return cubicles[cubicles.length - 1];
    }

    public static synchronized List<Cubicle> getMultipleMoveOutCube(CommonParams expectedParam, int num) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        IntStream.range(0, num).forEach(i -> {
            Cubicle cube = MainStorageAlgorithm.getAMoveOutCube(expectedParam);
            if (cube == null) {
                LOG.error("\u627e\u4e0d\u5230\u5408\u9002\u7684\u51fa\u5e93\u4f4d\uff01");
                return;
            }
            Bracket newBracket = new Bracket();
            cube.getMyBracket().copyTo(newBracket);
            expectedParam.setNewBracket(newBracket);
            cube.setStatus(StockStatus.locked_out);
            expectedParam.moveCar2Last(cube);
            ret.add(cube);
        });
        return ret;
    }

    public static synchronized List<Cubicle> getMultipleMoveOutCubeWithPackNumber(CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        expectedParam.initBeforeEverySearch();
        List<Cubicle> cubes = expectedParam.getSameCubicles().stream().filter(cubicle -> cubicle.getStatus() != StockStatus.locked_in && cubicle.getStatus() != StockStatus.locked_out).collect(Collectors.toList());
        List<Cubicle> ret = Categories.moveOutCubes3(cubes, expectedParam);
        ret.stream().forEach(cube -> cube.setStatus(StockStatus.locked_out));
        return ret;
    }

    public static synchronized List<Cubicle> moveBracket(CommonParams expectedParam) {
        Cubicle inCube;
        Cubicle outCube = MainStorageAlgorithm.getAMoveOutCube(expectedParam);
        if (outCube == null) {
            LOG.error("\u627e\u4e0d\u5230\u5408\u9002\u7684\u79fb\u51fa\u5e93\u4f4d\uff01");
            return null;
        }
        CommonParams expectedInParam = new CommonParams(Behavior.moveIn);
        outCube.getMyBracket().copyTo(expectedInParam);
        expectedInParam.setNewBracket(outCube.getMyBracket());
        outCube.setStatus(StockStatus.locked_out);
        if (outCube.getMyAlley().getDistrict().isShuttle()) {
            expectedInParam.addFixedFloor(outCube.getFloor());
        }
        if ((inCube = MainStorageAlgorithm.getARecommendedCube(expectedInParam)) == null || inCube.getRecommendedValue() < StorageConst.minimumRecommendedValue) {
            LOG.error("\u8d27\u7269 " + expectedInParam.getNewBracket() + " \u627e\u4e0d\u5230\u5408\u9002\u7684\u79fb\u5165\u5e93\u4f4d!");
            outCube.setBracket(expectedInParam.getNewBracket());
            outCube.setStatus(StockStatus.full);
            return null;
        }
        inCube.setBracket(expectedInParam.getNewBracket());
        inCube.setStatus(StockStatus.locked_in);
        return Stream.of(outCube, inCube).collect(Collectors.toList());
    }

    public static synchronized List<Cubicle> moveBracket(CommonParams expectedParam, int num) {
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        for (int i = 0; i < num; ++i) {
            List<Cubicle> tmp = MainStorageAlgorithm.moveBracket(expectedParam);
            if (tmp == null) {
                LOG.error("\u53ea\u627e\u5230" + i + "\u79fb\u5e93\u8d27\u7269 !");
                return ret;
            }
            ret.addAll(tmp);
        }
        return ret;
    }

    public static synchronized int[] countEmptyCubes(District district) {
        int[] ret = new int[district.getHeight()];
        district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().filter(cube -> cube.getStatus() == StockStatus.empty).forEach(cube -> {
            int n = cube.getFloor() - district.getMinZ();
            ret[n] = ret[n] + 1;
        }));
        return ret;
    }

    public static synchronized void clearCubicle(Cubicle cube) {
        cube.setStatus(StockStatus.empty);
    }

    public static synchronized void fullCubicle(Cubicle cube) {
        if (cube.getMyBracket() == null) {
            throw new StatusException(cube + " \u72b6\u6001\u4e0d\u4e00\u81f4\uff01");
        }
        cube.setStatus(StockStatus.full);
    }

    public static void resetWarhouse() {
        Warehouse.INST.getAllDistricts().stream().forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> {
            if (cube.getStatus() == StockStatus.locked_out) {
                cube.setBracket(null);
            }
            cube.resetStatus();
        })));
    }

    public static void cleanWarhouse() {
        Warehouse.INST.getAllDistricts().stream().forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> cube.setStatus(StockStatus.empty))));
    }

    public static synchronized void closeWarhouse() {
        Warehouse.INST.getAllDistricts().stream().forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> cube.setStatus(StockStatus.forbiden))));
    }

    public static void main(String[] args) {
        double[] deltas = new double[]{1.0, 1.0};
        int[] level = new int[]{0, 1};
        double[] xs1 = new double[]{0.1, 0.0};
        double[] xs2 = new double[]{0.0, 0.15};
        double[] wdeltas1 = new double[deltas.length];
        double[] wdeltas2 = new double[deltas.length];
        for (int i = 0; i < deltas.length; ++i) {
            wdeltas1[i] = StorageConst.calculateWeightedDelta(deltas[i], level[i], xs1[i]);
            wdeltas2[i] = StorageConst.calculateWeightedDelta(deltas[i], level[i], xs2[i]);
        }
        double[] cov = StorageConst.covDiagMatrix(deltas);
        double[] wcov1 = StorageConst.covDiagMatrix(wdeltas1);
        double[] wcov2 = StorageConst.covDiagMatrix(wdeltas2);
        double det1 = StorageConst.diagDet(wcov1);
        double det2 = StorageConst.diagDet(wcov2);
        double[] inv = StorageConst.diagMrinv(cov);
        double result1 = StorageConst.indepNormDistribution(inv, det1, xs1);
        double result2 = StorageConst.indepNormDistribution(inv, det2, xs2);
        System.out.println(result1);
        System.out.println(result2);
    }
}

