/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.base;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CargoLabel;
import com.wisdom.storalgorithm.element.base.Policy;
import com.wisdom.storalgorithm.element.base.PolicyFactory;
import com.wisdom.storalgorithm.exception.StatusException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Cargo {
    private static final Logger LOG = LoggerFactory.getLogger(Cargo.class);
    public static final String CARGO_OWNER = "\u8d27\u4e3b";
    public static final String CARGO_TYPE = "\u8d27\u7269\u54c1\u7c7b";
    public static final String CARGO_NAME = "\u8d27\u7269\u54c1\u540d";
    public static final String CARGO_QUALITY = "\u8d27\u7269\u8d28\u91cf";
    public static final String BILL_NUMBER = "\u63d0\u5355\u53f7";
    public static final String BATCH_NUMBER = "\u6279\u6b21";
    public static final String BATCH_ATTRIB = "\u6279\u6b21\u5c5e\u6027";
    public static final String PRODUCT_CODE = "\u4ea7\u54c1\u4ee3\u7801";
    public static final String PRODUCT_DESCRIPTION = "\u4ea7\u54c1\u63cf\u8ff0";
    public static final String PACKAGE_NUMBER = "\u8d27\u54c1\u4ef6\u6570";
    public static final String BOX_NUMBER = "\u8d27\u54c1\u7bb1\u6570";
    public static final String PIECE_NUMBER = "\u8d27\u54c1\u6563\u4ef6\u6570";
    public static final String TOTAL_NUMBER = "\u8d27\u54c1\u603b\u4ef6\u6570";
    public static final String BOX_ID = "\u7bb1\u53f7";
    public static final String RESERV_ATTRIB01 = "\u9884\u7559\u5c5e\u602701";
    public static final String RESERV_ATTRIB02 = "\u9884\u7559\u5c5e\u602702";
    public static final String RESERV_ATTRIB03 = "\u9884\u7559\u5c5e\u602703";
    public static final String RESERV_ATTRIB04 = "\u9884\u7559\u5c5e\u602704";
    public static final String RESERV_ATTRIB05 = "\u9884\u7559\u5c5e\u602705";
    public static final String RESERV_ATTRIB06 = "\u9884\u7559\u5c5e\u602706";
    public static final String RESERV_ATTRIB07 = "\u9884\u7559\u5c5e\u602707";
    public static final String RESERV_ATTRIB08 = "\u9884\u7559\u5c5e\u602708";
    public static final String RESERV_ATTRIB09 = "\u9884\u7559\u5c5e\u602709";
    public static final String RESERV_ATTRIB10 = "\u9884\u7559\u5c5e\u602710";
    public static final String RESERV_BATCH_ATTRIB01 = "\u9884\u7559\u6279\u6b21\u5c5e\u602701";
    public static final String RESERV_BATCH_ATTRIB02 = "\u9884\u7559\u6279\u6b21\u5c5e\u602702";
    public static final String RESERV_BATCH_ATTRIB03 = "\u9884\u7559\u6279\u6b21\u5c5e\u602703";
    public static final String RESERV_BATCH_ATTRIB04 = "\u9884\u7559\u6279\u6b21\u5c5e\u602704";
    public static final String RESERV_BATCH_ATTRIB05 = "\u9884\u7559\u6279\u6b21\u5c5e\u602705";
    public static final String RESERV_BATCH_ATTRIB06 = "\u9884\u7559\u6279\u6b21\u5c5e\u602706";
    public static final String RESERV_BATCH_ATTRIB07 = "\u9884\u7559\u6279\u6b21\u5c5e\u602707";
    public static final String RESERV_BATCH_ATTRIB08 = "\u9884\u7559\u6279\u6b21\u5c5e\u602708";
    public static final String RESERV_BATCH_ATTRIB09 = "\u9884\u7559\u6279\u6b21\u5c5e\u602709";
    public static final String RESERV_BATCH_ATTRIB10 = "\u9884\u7559\u6279\u6b21\u5c5e\u602710";
    private static final List<String> ATTRIBUTES = new ArrayList<String>();
    private final Map<String, CargoLabel> cargoLabels = new HashMap<String, CargoLabel>();

    public Cargo() {
        this.init();
    }

    private void init() {
        ATTRIBUTES.stream().forEach(attribute -> this.cargoLabels.put((String)attribute, new CargoLabel((String)attribute){

            @Override
            public Policy<String, Set<String>> policy() {
                return PolicyFactory.cargo_attrib_str.policy(null);
            }
        }));
        this.cargoLabels.get(CARGO_QUALITY).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(BOX_NUMBER).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(PACKAGE_NUMBER).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(PIECE_NUMBER).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(TOTAL_NUMBER).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(BOX_ID).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(BILL_NUMBER).setMode(AlgorithomMode.IGNORE);
        this.cargoLabels.get(PRODUCT_DESCRIPTION).setMode(AlgorithomMode.IGNORE);
    }

    public String get(String name) {
        CargoLabel label = this.cargoLabels.get(name);
        if (label == null) {
            throw new StatusException("\u7c7b\u578b " + name + " \u5728\u8d27\u7269\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        return this.cargoLabels.get(name).getValue();
    }

    public int getInt(String name) {
        String value = this.get(name);
        if (value == null) {
            return 0;
        }
        return Integer.valueOf(value);
    }

    public CargoLabel getLabel(String name) {
        CargoLabel label = this.cargoLabels.get(name);
        if (label == null) {
            throw new StatusException("\u7c7b\u578b " + name + " \u5728\u8d27\u7269\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        return label;
    }

    public void set(String name, String value) {
        CargoLabel label = this.cargoLabels.get(name);
        if (label == null) {
            throw new StatusException("\u7c7b\u578b " + name + " \u5728\u8d27\u7269\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        label.setValue(value);
    }

    public void set(String name, int value) {
        CargoLabel label = this.cargoLabels.get(name);
        if (label == null) {
            throw new StatusException("\u7c7b\u578b " + name + " \u5728\u8d27\u7269\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        label.setValue(String.valueOf(value));
    }

    public void mixLabel(String name) {
        CargoLabel label = this.cargoLabels.get(name);
        if (label == null) {
            throw new StatusException("\u7c7b\u578b " + name + " \u5728\u8d27\u7269\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        label.clearExpectedValues();
    }

    public void mixAllLabels() {
        this.cargoLabels.values().stream().forEach(label -> label.clearExpectedValues());
    }

    public Collection<CargoLabel> getLabels() {
        return this.cargoLabels.values();
    }

    public void copyTo(Cargo cargo) {
        for (String key : this.cargoLabels.keySet()) {
            this.cargoLabels.get(key).copyTo(cargo.cargoLabels.get(key));
        }
    }

    public boolean compatibleWith(Cargo cargo) {
        for (String key : this.cargoLabels.keySet()) {
            if (this.cargoLabels.get(key).getMode() == AlgorithomMode.IGNORE || this.cargoLabels.get(key).isIn(cargo.cargoLabels.get(key).getValue())) continue;
            return false;
        }
        return true;
    }

    public void addExpectedValue(String label, String expectedValue) {
        this.cargoLabels.get(label).addExpectedValues(expectedValue);
    }

    public boolean equals(Object cargo) {
        if (!(cargo instanceof Cargo)) {
            return false;
        }
        Cargo tmp = (Cargo)cargo;
        for (String key : this.cargoLabels.keySet()) {
            if (this.cargoLabels.get(key).getMode() == AlgorithomMode.IGNORE || StringUtils.equals((CharSequence)this.cargoLabels.get(key).getValue(), (CharSequence)tmp.cargoLabels.get(key).getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.cargoLabels.values().stream().filter(label -> label.getValue() != null && !label.getValue().isEmpty()).map(label -> label.toString()).collect(Collectors.joining("\n", this.getClass().getSimpleName() + ": \n", ""));
    }

    static {
        Arrays.asList(Cargo.class.getDeclaredFields()).stream().filter(field -> field.getType() == String.class && Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && Modifier.isPublic(field.getModifiers())).forEach(field -> {
            try {
                ATTRIBUTES.add(field.get(null).toString());
            }
            catch (Exception e) {
                LOG.error("Cargo \u89e3\u6790\u9519\u8bef", (Throwable)e);
            }
        });
    }
}

