/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.base;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.Label;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CargoLabel
implements Label<String, Set<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(CargoLabel.class);
    private String value = null;
    private final Set<String> expectedValues = new HashSet<String>();
    private AlgorithomMode mode = AlgorithomMode.UNIFORM;
    private String name;

    public CargoLabel(String name) {
        this.name = name;
    }

    @Override
    public String tag() {
        return this.policy().name();
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.expectedValues.add(value);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + "\u8bbe\u7f6e\u503c " + value);
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void addExpectedValues(String expectedValue) {
        LOG.info(this + "\u6dfb\u52a0\u6df7\u8d27\u503c " + expectedValue);
        this.expectedValues.add(expectedValue);
    }

    public void copyTo(CargoLabel label) {
        if (!this.name.equals(label.name)) {
            LOG.error("\u4e0d\u540c\u6807\u7b7e\uff08" + this.name + " " + label.name + "\uff09\u4e0d\u5141\u8bb8\u4e92\u62f7\uff01");
            return;
        }
        label.value = this.value;
        label.expectedValues.clear();
        label.expectedValues.addAll(this.expectedValues);
    }

    public boolean isIn(String value) {
        if (this.expectedValues.isEmpty()) {
            return true;
        }
        return this.expectedValues.contains(value);
    }

    public void clearExpectedValues() {
        LOG.info(this + "\u6e05\u9664\u6df7\u8d27\u503c");
        this.expectedValues.clear();
    }

    public AlgorithomMode getMode() {
        return this.mode;
    }

    public void setMode(AlgorithomMode mode) {
        this.mode = mode;
    }

    @Override
    public double getX() {
        return this.policy().x(this.getValue(), this.expectedValues);
    }

    public String toString() {
        return "\u6807\u7b7e " + this.getName() + "=" + this.value + ", \u5f52\u7c7b\u4e8e: " + this.expectedValues.stream().collect(Collectors.joining(", "));
    }
}

