/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.base;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.exception.StatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Policy<E, V>
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Policy.class);
    public static final double MINDELTA = 0.05;
    public static final double MAXDELTA = 4.05;
    public static final int MINLEVEL = 0;
    public static final int DEFAULTLEVEL = 5;
    public static final int MAXLEVEL = 10;
    public static final double EXCLUDEED = 20.0;
    public static final double NARROWLEVEL = 1.0;
    private int level = 5;
    private double expecting = 0.0;
    private double delta = 1.0;
    protected AlgorithomMode mode = AlgorithomMode.SUGGEST;
    protected String name;

    public abstract double x(E var1, V var2);

    public Policy(String name) {
        this.name = name;
    }

    protected double excludedXValue() {
        return this.delta * 20.0 + this.expecting;
    }

    protected double availableMaxXValue() {
        return this.interval() * 10.0 + this.expecting;
    }

    private double interval() {
        return this.delta * 2.0 / 10.0;
    }

    protected double getMappedValue(double x, double minX, double maxX) {
        return (x - minX) / (maxX - minX) + this.expecting;
    }

    protected double getMappedValue(int x, int minX, int maxX) {
        return (double)(x - minX) * 1.0 / (double)(maxX - minX) + this.expecting;
    }

    protected double getDefaultExcludedValue() {
        switch (this.mode) {
            case UNIFORM: {
                return this.excludedXValue();
            }
        }
        return this.availableMaxXValue();
    }

    protected double getMappedValue(double x) {
        return x * 10.0 * this.interval() + this.expecting;
    }

    protected double ignoreValue() {
        return this.expecting;
    }

    public void setTopLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > 10) {
            level = 10;
        }
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setDefaultLevel() {
        this.level = 5;
    }

    public double delta() {
        return this.delta;
    }

    public void setExpecting(double mue) {
        LOG.info("\u7b56\u7565" + this.name + " \u8bbe\u7f6e\u671f\u671b\u503c\u4e3a  " + mue);
        this.expecting = mue;
    }

    public void setMode(AlgorithomMode mode) {
        this.mode = mode;
        LOG.info("\u7b56\u7565" + this.name + " \u66f4\u6539\u6a21\u5f0f\u4e3a " + this.mapMode());
    }

    public AlgorithomMode getMode() {
        return this.mode;
    }

    public String name() {
        return this.name;
    }

    protected String mapMode() {
        switch (this.mode) {
            case UNIFORM: {
                return "\u5f3a\u4e00\u81f4";
            }
            case SUGGEST: {
                return "\u63a8\u8350\u4e00\u81f4";
            }
            case IGNORE: {
                return "\u5ffd\u7565";
            }
            case ALGORITHOM1: {
                return "\u7b97\u6cd51";
            }
            case ALGORITHOM2: {
                return "\u7b97\u6cd52";
            }
        }
        return "\u672a\u77e5\u7b97\u6cd5";
    }

    protected String mapLevels() {
        return "\u4f18\u5148\u7ea7 " + this.level + ", \u65b9\u5dee" + this.delta + ", \u671f\u671b" + this.expecting;
    }

    public Policy<E, V> copy() {
        try {
            return (Policy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new StatusException(this + " copy error: " + e);
        }
    }
}

