/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.base;

import com.wisdom.storalgorithm.element.base.Policy;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.policy.FragmentStock;
import com.wisdom.storalgorithm.policy.Inside2Outside;
import com.wisdom.storalgorithm.policy.InternalFirst;
import com.wisdom.storalgorithm.policy.LiftBuffer;
import com.wisdom.storalgorithm.policy.PackNumber;
import com.wisdom.storalgorithm.policy.PolicyFloorOrder;
import com.wisdom.storalgorithm.policy.PolicyFloorSelection;
import com.wisdom.storalgorithm.policy.PolicyForbidStore;
import com.wisdom.storalgorithm.policy.PolicyGroups;
import com.wisdom.storalgorithm.policy.PolicyIdenticalNeighborhood;
import com.wisdom.storalgorithm.policy.PolicyLeaveEmpties;
import com.wisdom.storalgorithm.policy.PolicyLeaveEmptyStocks;
import com.wisdom.storalgorithm.policy.PolicyLeft2Alley;
import com.wisdom.storalgorithm.policy.PolicyLeftCargo;
import com.wisdom.storalgorithm.policy.PolicyMissoinControl;
import com.wisdom.storalgorithm.policy.PolicyMixCargo;
import com.wisdom.storalgorithm.policy.PolicyPosition;
import com.wisdom.storalgorithm.policy.PolicyScatter;
import com.wisdom.storalgorithm.policy.PolicyShelfBearing;
import com.wisdom.storalgorithm.policy.PolicyShuttleFixFloors;
import com.wisdom.storalgorithm.policy.PolicyShuttleLimitedFloorNumber;
import com.wisdom.storalgorithm.policy.PolicyShuttleSelection;
import com.wisdom.storalgorithm.policy.PolicyStackerFixFloors;
import com.wisdom.storalgorithm.policy.PolicyStackerGroups;
import com.wisdom.storalgorithm.policy.PolicyStackerLimitedNumber;
import com.wisdom.storalgorithm.policy.PolicyStackerMissions;
import com.wisdom.storalgorithm.policy.PolicyStackerSelection;
import com.wisdom.storalgorithm.policy.PolicyStockSize;
import com.wisdom.storalgorithm.policy.ShuttleInternalFirst;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum PolicyFactory {
    cargo_attrib_str(new PolicyScatter<E>("\u79bb\u6563\u7c7b\u578b")),
    shelf_bearer(new PolicyShelfBearing("\u8d27\u67b6\u627f\u91cd")),
    floor_order(new PolicyFloorOrder("\u697c\u5c42\u987a\u5e8f")),
    store_forbidden(new PolicyForbidStore("\u533a\u57df\u7981\u7528")),
    position(new PolicyPosition("\u805a\u96c6\u653e\u7f6e")),
    in2out(new Inside2Outside("\u7531\u5185\u5411\u5916\u653e\u7f6e")),
    internal_first(new InternalFirst("\u5185\u4fa7\u4f18\u5148")),
    fragment_stock(new FragmentStock("\u6b8b\u5df7\u9053\u4f18\u5148")),
    mix_cargo(new PolicyMixCargo("\u8d27\u7269\u6df7\u653e")),
    leave_empties(new PolicyLeaveEmptyStocks("\u4fdd\u7559\u7a7a\u4f59\u8d27\u4f4d")),
    pack_number(new PackNumber("\u8d27\u6258\u4ef6\u6570\u9009\u62e9")),
    stacker_groups(new PolicyStackerGroups("\u5806\u579b\u673a\u5206\u7ec4")),
    groups(new PolicyGroups("\u5206\u7ec4\u7b56\u7565")),
    stacker_selection(new PolicyStackerSelection("\u5806\u579b\u673a\u9009\u62e9")),
    stacker_mission(new PolicyStackerMissions("\u5806\u579b\u673a\u4efb\u52a1\u8d1f\u8f7d\u5747\u8861")),
    shuttle_floor_selection(new PolicyFloorSelection("\u7a7f\u68ad\u8f66\u697c\u5c42\u9009\u62e9")),
    shuttle_selection(new PolicyShuttleSelection("\u7a7f\u68ad\u8f66\u9009\u62e9")),
    shuttle_internal_first(new ShuttleInternalFirst("\u4e2d\u90e8\u4f18\u5148")),
    shuttle_fix_floors(new PolicyShuttleFixFloors("\u6307\u5b9a\u8fd0\u8d27\u697c\u5c42")),
    shuttle_limited_floor_number(new PolicyShuttleLimitedFloorNumber("\u6307\u5b9a\u5165\u5e93\u697c\u5c42\u6570\u91cf")),
    stacker_limited_number(new PolicyStackerLimitedNumber("\u5806\u579b\u673a\u6570\u91cf\u9650\u5236\u7b56\u7565")),
    stacker_fix_floors(new PolicyStackerFixFloors("\u5806\u579b\u673a\u6307\u5b9a\u697c\u5c42\u5165\u5e93\u7b56\u7565")),
    left_cargo(new PolicyLeftCargo("\u5269\u4f59\u8d27\u7269\u9884\u6d4b\u7b56\u7565")),
    stock_size(new PolicyStockSize("\u5e93\u4f4d\u5c3a\u5bf8\u9009\u62e9\u7b56\u7565")),
    shuttle_mission(new PolicyMissoinControl("\u6bcf\u5c42\u4efb\u52a1\u6570\u91cf\u63a7\u5236\u7b56\u7565")),
    shuttle_leave_empties(new PolicyLeaveEmpties("\u6bcf\u5c42\u4fdd\u7559\u7a7a\u4f59\u8d27\u4f4d")),
    identical_neighbor(new PolicyIdenticalNeighborhood("\u76f8\u90bb\u8d27\u7269\u4e00\u81f4\u7b56\u7565")),
    left_into_alley(new PolicyLeft2Alley("\u7559\u7a7a\u5df7\u9053\u7b56\u7565")),
    lift_buffer(new LiftBuffer("\u5347\u964d\u673a\u8d27\u7269\u6392\u5217\u7b56\u7565"));

    private final Policy<?, ?> templatePolicy;
    private final Map<String, Policy<?, ?>> disPolicies = new ConcurrentHashMap();

    private PolicyFactory(Policy<?, ?> policy) {
        this.templatePolicy = policy;
    }

    public String tag() {
        return this.templatePolicy.name;
    }

    public Policy<?, ?> policy(District myDistrict) {
        if (myDistrict == null) {
            return this.templatePolicy;
        }
        Policy<?, ?> ret = this.disPolicies.get(myDistrict.getId());
        if (ret == null) {
            ret = this.templatePolicy.copy();
            this.disPolicies.put(myDistrict.getId(), ret);
        }
        return ret;
    }
}

