/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.base;

import com.wisdom.storalgorithm.element.base.Priority;
import com.wisdom.storalgorithm.element.base.StockSize;
import com.wisdom.storalgorithm.element.base.StockStatus;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Stock
implements Comparable<Stock> {
    private static final Logger LOG = LoggerFactory.getLogger(Stock.class);
    private Priority priority = Priority.NORMAL;
    private StockStatus status = StockStatus.empty;
    protected StockSize size = StockSize.Normal;
    private String physicalAreaCode;
    private String matMilitaryType;
    private String matTemperatureType;
    private String lockSource;
    private double recommendedValue;
    private int distanceSteps = -1;
    private final String id;
    protected int depth = -1;

    public Stock(String id) {
        this.id = id;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public StockStatus getStatus() {
        return this.status;
    }

    public void setStatus(StockStatus status) {
        this.status = status;
    }

    public String getPhysicalAreaCode() {
        return this.physicalAreaCode;
    }

    public void setPhysicalAreaCode(String physicalAreaCode) {
        this.physicalAreaCode = physicalAreaCode;
    }

    public String getMatMilitaryType() {
        return this.matMilitaryType;
    }

    public void setMatMilitaryType(String matMilitaryType) {
        this.matMilitaryType = matMilitaryType;
    }

    public String getMatTemperatureType() {
        return this.matTemperatureType;
    }

    public void setMatTemperatureType(String matTemperatureType) {
        this.matTemperatureType = matTemperatureType;
    }

    public String getId() {
        return this.id;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public double getRecommendedValue() {
        return this.recommendedValue;
    }

    public void setRecommendedValue(double recommendedValue) {
        this.recommendedValue = recommendedValue;
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " \u83b7\u5f97\u63a8\u8350\u503c " + recommendedValue);
        }
    }

    public int getDistanceSteps() {
        return this.distanceSteps;
    }

    public void setDistanceSteps(int distanceSteps) {
        this.distanceSteps = distanceSteps;
    }

    @Override
    public int compareTo(Stock stock) {
        Double myRec = this.recommendedValue;
        return myRec.compareTo(stock.recommendedValue);
    }

    public StockSize getSize() {
        return this.size;
    }

    public boolean equals(Object stock) {
        if (stock == null) {
            return false;
        }
        if (this.getClass() != stock.getClass()) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.id, (CharSequence)((Stock)stock).id);
    }

    public String toString() {
        return this.getId();
    }
}

